/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.storage.MessageStore;
import net.morimekta.providence.storage.dir.DefaultFileManager;
import net.morimekta.providence.storage.dir.FileManager;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class DirectoryMessageStore<K, M extends PMessage<M, F>, F extends PField>
implements MessageStore<K, M, F>,
Closeable {
    private final ReadWriteMutex mutex;
    private final Set<K> keyset;
    private final FileManager<K> manager;
    private final Serializer serializer;
    private final PMessageDescriptor<M, F> descriptor;
    private final Cache<K, M> cache;

    public DirectoryMessageStore(@Nonnull File directory, @Nonnull Function<K, String> keyBuilder, @Nonnull Function<String, K> keyParser, @Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull Serializer serializer) {
        this(directory.toPath(), keyBuilder, keyParser, descriptor, serializer);
    }

    public DirectoryMessageStore(@Nonnull Path directory, @Nonnull Function<K, String> keyBuilder, @Nonnull Function<String, K> keyParser, @Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull Serializer serializer) {
        this(new DefaultFileManager<K>(directory, keyBuilder, keyParser), descriptor, serializer);
    }

    public DirectoryMessageStore(@Nonnull FileManager<K> manager, @Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull Serializer serializer) {
        this.manager = manager;
        this.mutex = new ReentrantReadWriteMutex();
        this.keyset = new HashSet<K>(manager.initialKeySet());
        this.descriptor = descriptor;
        this.serializer = serializer;
        this.cache = CacheBuilder.newBuilder().build();
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.keyset.contains(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> ImmutableSet.copyOf(this.keyset));
    }

    @Override
    @Nonnull
    public Map<K, M> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            TreeSet tmp = new TreeSet(keys);
            tmp.retainAll(this.keyset);
            for (Object key : tmp) {
                try {
                    out.put(key, (PMessage)this.cache.get(key, () -> this.read(key)));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Unable to read " + key.toString(), e);
                }
            }
            return out;
        });
    }

    @Override
    @Nonnull
    public Map<K, M> putAll(@Nonnull Map<K, M> values) {
        return (Map)this.mutex.lockForWriting(() -> {
            Map out = this.getAll(values.keySet());
            values.forEach((key, value) -> {
                try {
                    this.write(key, value);
                    this.cache.put(key, value);
                    this.keyset.add(key);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e.getMessage(), e);
                }
            });
            return out;
        });
    }

    @Override
    @Nonnull
    public Map<K, M> removeAll(Collection<K> keys) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                Path file = this.manager.getFileFor(key);
                if (!Files.exists(file, new LinkOption[0])) continue;
                try {
                    out.put(key, (PMessage)this.cache.get(key, () -> this.read(key)));
                }
                catch (ExecutionException e) {
                    out.put(key, (PMessage)this.descriptor.builder().build());
                }
                finally {
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException iOException) {}
                }
                this.cache.invalidate(key);
                this.keyset.remove(key);
            }
            return out;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private M read(K key) throws IOException {
        try {
            Throwable throwable = null;
            try (FileInputStream fis = new FileInputStream(this.manager.getFileFor(key).toFile());){
                PMessage pMessage;
                BufferedInputStream bis = new BufferedInputStream(fis);
                Throwable throwable2 = null;
                try {
                    pMessage = this.serializer.deserialize((InputStream)bis, this.descriptor);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            DirectoryMessageStore.$closeResource(throwable2, bis);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                DirectoryMessageStore.$closeResource(throwable2, bis);
                return (M)pMessage;
            }
        }
        catch (FileNotFoundException fnf) {
            return null;
        }
        catch (IOException e) {
            throw new IOException("Unable to read " + key.toString(), e);
        }
    }

    private void write(K key, M message) throws IOException {
        Path tmp = this.manager.tmpFileFor(key);
        Path file = this.manager.getFileFor(key);
        try (FileOutputStream fos = new FileOutputStream(tmp.toFile(), false);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            this.serializer.serialize((OutputStream)bos, message);
            bos.flush();
        }
        catch (IOException e) {
            throw new IOException("Unable to write " + key.toString(), e);
        }
        Files.move(tmp, file, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public void close() {
        this.cache.invalidateAll();
        this.keyset.clear();
    }
}

