/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.dir;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.storage.dir.FileManager;

public class DefaultFileManager<K>
implements FileManager<K> {
    private static final String TMP_DIR = ".tmp";
    private final File directory;
    private final File tempDir;
    private final Function<String, K> keyParser;
    private final Function<K, String> keyBuilder;

    public DefaultFileManager(@Nonnull File directory, @Nonnull Function<K, String> keyBuilder, @Nonnull Function<String, K> keyParser) {
        try {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + directory.toString());
            }
            this.directory = directory.getCanonicalFile();
            this.tempDir = new File(directory, TMP_DIR);
            if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
                throw new IllegalStateException("Unable to create temp directory: " + this.tempDir.toString());
            }
            if (!this.tempDir.isDirectory()) {
                throw new IllegalStateException("File blocking temp directory: " + this.tempDir.toString());
            }
            this.keyBuilder = keyBuilder;
            this.keyParser = keyParser;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public File getFileFor(@Nonnull K key) {
        return new File(this.directory, this.validateKey(this.keyBuilder.apply(key)));
    }

    @Override
    public File tmpFileFor(@Nonnull K key) {
        return new File(this.tempDir, this.validateKey(this.keyBuilder.apply(key)));
    }

    @Override
    public Collection<K> initialKeySet() {
        HashSet<K> set = new HashSet<K>();
        for (String file : this.directory.list()) {
            if (!new File(this.directory, file).isFile()) continue;
            try {
                set.add(this.keyParser.apply(file));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to get key from file: " + file, e);
            }
        }
        return set;
    }

    private String validateKey(String key) {
        if (key.contains(File.separator)) {
            throw new IllegalArgumentException("Path name separator in key " + key);
        }
        return key;
    }
}

