/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageListReadOnlyStore;
import net.morimekta.providence.storage.MessageStoreUtils;

public interface MessageListStore<K, M extends PMessage<M, F>, F extends PField>
extends MessageListReadOnlyStore<K, M, F> {
    @Nonnull
    public Map<K, List<M>> putAll(@Nonnull Map<K, List<M>> var1);

    @Nonnull
    public Map<K, List<M>> removeAll(Collection<K> var1);

    @Nullable
    default public List<M> put(@Nonnull K key, @Nonnull List<M> list) {
        return this.putAll((Map<K, List<M>>)ImmutableMap.of(key, list)).get(key);
    }

    @Nullable
    default public List<M> remove(@Nonnull K key) {
        return this.removeAll((Collection<K>)ImmutableList.of(key)).get(key);
    }

    @Nullable
    default public <B extends PMessageBuilder<M, F>> List<B> putBuilders(@Nonnull K key, @Nonnull List<B> builders) {
        return MessageStoreUtils.mutateAll(this.put(key, MessageStoreUtils.buildAll(builders)));
    }

    @Nonnull
    default public <B extends PMessageBuilder<M, F>> Map<K, List<B>> putAllBuilders(@Nonnull Map<K, List<B>> builders) {
        HashMap instances = new HashMap();
        builders.forEach((k, bList) -> instances.put(k, MessageStoreUtils.buildAll(bList)));
        Map<Object, List<M>> replaced = this.putAll(instances);
        HashMap result = new HashMap();
        replaced.forEach((k, list) -> result.put(k, MessageStoreUtils.mutateAll(list)));
        return result;
    }
}

