/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageStoreUtils;

public interface MessageListReadOnlyStore<K, M extends PMessage<M, F>, F extends PField> {
    @Nonnull
    public Map<K, List<M>> getAll(@Nonnull Collection<K> var1);

    public boolean containsKey(@Nonnull K var1);

    @Nonnull
    public Collection<K> keys();

    @Nullable
    default public List<M> get(@Nonnull K key) {
        return this.getAll((Collection<K>)ImmutableList.of(key)).get(key);
    }

    @Nullable
    default public <B extends PMessageBuilder<M, F>> List<B> getBuilders(@Nonnull K key) {
        return MessageStoreUtils.mutateAll(this.get(key));
    }

    @Nonnull
    default public <B extends PMessageBuilder<M, F>> Map<K, List<B>> getAllBuilders(@Nonnull Collection<K> keys) {
        HashMap out = new HashMap();
        this.getAll(keys).forEach((k, list) -> out.put(k, MessageStoreUtils.mutateAll(list)));
        return out;
    }
}

