/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageStore;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class InMemoryMessageStore<K, M extends PMessage<M, F>, F extends PField>
implements MessageStore<K, M, F> {
    private final Map<K, M> map = new HashMap<K, M>();
    private final ReadWriteMutex mutex = new ReentrantReadWriteMutex();

    @Override
    @Nonnull
    public Map<K, M> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                if (!this.map.containsKey(key)) continue;
                out.put(key, this.map.get(key));
            }
            return ImmutableMap.copyOf(out);
        });
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.map.containsKey(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> ImmutableSet.copyOf(this.map.keySet()));
    }

    @Override
    @Nonnull
    public Map<K, M> putAll(@Nonnull Map<K, M> values) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap out = new HashMap();
            for (Map.Entry entry : values.entrySet()) {
                PMessage tmp = (PMessage)this.map.put(entry.getKey(), entry.getValue());
                if (tmp == null) continue;
                out.put(entry.getKey(), tmp);
            }
            return out;
        });
    }

    @Override
    @Nonnull
    public Map<K, M> removeAll(Collection<K> keys) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                PMessage tmp = (PMessage)this.map.remove(key);
                if (tmp == null) continue;
                out.put(key, tmp);
            }
            return out;
        });
    }
}

