/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageSetStore;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class InMemoryMessageSetStore<K, M extends PMessage<M, F>, F extends PField>
implements MessageSetStore<K, M, F> {
    private final Map<K, M> map;
    private final ReadWriteMutex mutex;
    private final Function<M, K> messageToKey;

    public InMemoryMessageSetStore(Function<M, K> messageToKey) {
        this.messageToKey = messageToKey;
        this.map = new HashMap<K, M>();
        this.mutex = new ReentrantReadWriteMutex();
    }

    @Override
    @Nonnull
    public Map<K, M> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                if (!this.map.containsKey(key)) continue;
                out.put(key, this.map.get(key));
            }
            return out;
        });
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.map.containsKey(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> new HashSet<K>(this.map.keySet()));
    }

    @Override
    @Nonnull
    public Map<K, M> putAll(@Nonnull Collection<M> values) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap<K, PMessage> out = new HashMap<K, PMessage>(values.size());
            for (PMessage entry : values) {
                K key = this.messageToKey.apply(entry);
                PMessage tmp = this.map.put(key, entry);
                if (tmp == null) continue;
                out.put(key, tmp);
            }
            return out;
        });
    }

    @Override
    @Nonnull
    public Map<K, M> removeAll(Collection<K> keys) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap out = new HashMap(keys.size());
            for (Object key : keys) {
                PMessage tmp = (PMessage)this.map.remove(key);
                if (tmp == null) continue;
                out.put(key, tmp);
            }
            return out;
        });
    }
}

