/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.dir;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.morimekta.providence.storage.dir.FileManager;
import net.morimekta.util.FileUtil;

public class StringKeyFileManager
implements FileManager<String> {
    private static final String TMP_DIR = ".tmp";
    private final Path directory;
    private final Path tempDir;

    public StringKeyFileManager(@Nonnull Path directory) {
        try {
            if (!Files.isDirectory(directory, new LinkOption[0])) {
                throw new IllegalArgumentException("Not a directory: " + directory.toString());
            }
            this.directory = FileUtil.readCanonicalPath((Path)directory);
            this.tempDir = this.directory.resolve(TMP_DIR);
            if (!Files.exists(this.tempDir, new LinkOption[0])) {
                Files.createDirectories(this.tempDir, new FileAttribute[0]);
            } else if (!Files.isDirectory(this.tempDir, new LinkOption[0])) {
                throw new IllegalStateException("File blocking temp directory: " + this.tempDir.toString());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
    }

    @Override
    public Path getFileFor(@Nonnull String key) {
        return this.directory.resolve(this.validateKey(key));
    }

    @Override
    public Path tmpFileFor(@Nonnull String key) {
        return this.tempDir.resolve(this.validateKey(key));
    }

    @Override
    public Collection<String> initialKeySet() {
        HashSet<String> set = new HashSet<String>();
        try {
            Files.list(this.directory).forEach(file -> {
                if (Files.isRegularFile(file, new LinkOption[0])) {
                    try {
                        set.add(file.getFileName().toString());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to get key from file: " + file, e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Storage directory no longer a directory.", e);
        }
        return set;
    }

    private String validateKey(String key) {
        if ((key = Normalizer.normalize(key, Normalizer.Form.NFKC)).startsWith(".")) {
            throw new IllegalArgumentException("Special file char in start of key " + key);
        }
        if (key.contains(File.separator)) {
            throw new IllegalArgumentException("Path name separator in key " + key);
        }
        return key;
    }
}

