/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.storage.ReadOnlyStore;
import net.morimekta.util.collect.UnmodifiableSet;

public interface ReadWriteSetStore<K, V>
extends ReadOnlyStore<K, V> {
    @Nonnull
    public Map<K, V> putAll(@Nonnull Collection<V> var1);

    @Nonnull
    public Map<K, V> removeAll(Collection<K> var1);

    @Nullable
    default public V put(@Nonnull V value) {
        Iterator<V> tmp = this.putAll((Collection<V>)UnmodifiableSet.setOf(value)).values().iterator();
        if (tmp.hasNext()) {
            return tmp.next();
        }
        return null;
    }

    @Nullable
    default public V remove(@Nonnull K key) {
        Iterator<V> tmp = this.removeAll((Collection<K>)UnmodifiableSet.setOf(key)).values().iterator();
        if (tmp.hasNext()) {
            return tmp.next();
        }
        return null;
    }
}

