/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageReadOnlyStore;
import net.morimekta.providence.storage.MessageStoreUtils;
import net.morimekta.providence.storage.ReadWriteSetStore;

public interface MessageSetStore<K, M extends PMessage<M, F>, F extends PField>
extends MessageReadOnlyStore<K, M, F>,
ReadWriteSetStore<K, M> {
    @Nullable
    default public <B extends PMessageBuilder<M, F>> B putBuilder(@Nonnull B builder) {
        return MessageStoreUtils.mutateIfNotNull(this.put((PMessage)builder.build()));
    }

    @Nonnull
    default public <B extends PMessageBuilder<M, F>> Map<K, B> putAllBuilders(@Nonnull Collection<B> builders) {
        return MessageStoreUtils.mutateValues(this.putAll(MessageStoreUtils.buildAll(builders)));
    }
}

