/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;

public class MessageStoreUtils {
    public static <M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>> List<M> buildAll(Collection<B> builders) {
        if (builders == null) {
            return null;
        }
        return builders.stream().map(PBuilder::build).collect(Collectors.toList());
    }

    public static <M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>> List<B> mutateAll(Collection<M> messages) {
        if (messages == null) {
            return null;
        }
        return messages.stream().map(PMessage::mutate).collect(Collectors.toList());
    }

    public static <K, M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>> Map<K, B> mutateValues(Map<K, M> messages) {
        if (messages == null) {
            return null;
        }
        return messages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PMessage)e.getValue()).mutate()));
    }

    public static <K, M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>> Map<K, M> buildValues(Map<K, B> messages) {
        if (messages == null) {
            return null;
        }
        return messages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (PMessage)((PMessageBuilder)e.getValue()).build()));
    }

    public static <M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>> M buildIfNotNull(B builder) {
        if (builder == null) {
            return null;
        }
        return (M)((PMessage)builder.build());
    }

    public static <M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>> B mutateIfNotNull(M message) {
        if (message == null) {
            return null;
        }
        return (B)message.mutate();
    }
}

