/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageReadOnlyStore;
import net.morimekta.providence.storage.MessageStoreUtils;

public interface MessageStore<K, M extends PMessage<M, F>, F extends PField>
extends MessageReadOnlyStore<K, M, F> {
    @Nonnull
    public Map<K, M> putAll(@Nonnull Map<K, M> var1);

    @Nonnull
    public Map<K, M> removeAll(Collection<K> var1);

    @Nullable
    default public M put(@Nonnull K key, @Nonnull M message) {
        return (M)((PMessage)this.putAll((Map<K, M>)ImmutableMap.of(key, message)).get(key));
    }

    @Nullable
    default public M remove(@Nonnull K key) {
        return (M)((PMessage)this.removeAll((Collection<K>)ImmutableList.of(key)).get(key));
    }

    @Nullable
    default public <B extends PMessageBuilder<M, F>> B putBuilder(@Nonnull K key, @Nonnull B builder) {
        return MessageStoreUtils.mutateIfNotNull(this.put(key, (PMessage)builder.build()));
    }

    @Nonnull
    default public <B extends PMessageBuilder<M, F>> Map<K, B> putAllBuilders(@Nonnull Map<K, B> builders) {
        HashMap instances = new HashMap();
        builders.forEach((k, b) -> {
            PMessage cfr_ignored_0 = (PMessage)instances.put(k, b.build());
        });
        Map<Object, PMessage> replaced = this.putAll(instances);
        HashMap out = new HashMap();
        replaced.forEach((k, m) -> out.put(k, m.mutate()));
        return out;
    }
}

