/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.storage.MessageStore;
import net.morimekta.util.concurrent.ReadWriteMutex;
import net.morimekta.util.concurrent.ReentrantReadWriteMutex;

public class DirectoryMessageStore<K, M extends PMessage<M, F>, F extends PField>
implements MessageStore<K, M, F>,
Closeable {
    private static final String TMP_DIR = ".tmp";
    private final File directory;
    private final File tempDir;
    private final Function<K, String> keyBuilder;
    private final Function<String, K> keyParser;
    private final Serializer serializer;
    private final PMessageDescriptor<M, F> descriptor;
    private final ReadWriteMutex mutex;
    private final Cache<K, M> cache;
    private final Set<K> keyset;

    public DirectoryMessageStore(@Nonnull File directory, @Nonnull Function<K, String> keyBuilder, @Nonnull Function<String, K> keyParser, @Nonnull PMessageDescriptor<M, F> descriptor, @Nonnull Serializer serializer) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directory.toString());
        }
        this.directory = directory;
        this.tempDir = new File(directory, TMP_DIR);
        if (!this.tempDir.exists() && !this.tempDir.mkdirs()) {
            throw new IllegalStateException("Unable to create temp directory: " + this.tempDir.toString());
        }
        if (!this.tempDir.isDirectory()) {
            throw new IllegalStateException("File blocking temp directory: " + this.tempDir.toString());
        }
        this.keyBuilder = keyBuilder;
        this.keyParser = keyParser;
        this.descriptor = descriptor;
        this.serializer = serializer;
        this.mutex = new ReentrantReadWriteMutex();
        this.cache = CacheBuilder.newBuilder().build();
        this.keyset = this.initKeySet();
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        return (Boolean)this.mutex.lockForReading(() -> this.keyset.contains(key));
    }

    @Override
    @Nonnull
    public Collection<K> keys() {
        return (Collection)this.mutex.lockForReading(() -> ImmutableSet.copyOf(this.keyset));
    }

    @Override
    @Nonnull
    public Map<K, M> getAll(@Nonnull Collection<K> keys) {
        return (Map)this.mutex.lockForReading(() -> {
            HashMap out = new HashMap();
            TreeSet tmp = new TreeSet(keys);
            tmp.retainAll(this.keyset);
            for (Object key : tmp) {
                try {
                    out.put(key, this.cache.get(key, () -> this.read(key)));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Unable to read " + this.keyBuilder.apply(key), e);
                }
            }
            return out;
        });
    }

    @Override
    @Nonnull
    public Map<K, M> putAll(@Nonnull Map<K, M> values) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap out = new HashMap();
            values.forEach((key, value) -> {
                try {
                    this.write(key, value);
                    this.cache.put(key, value);
                    this.keyset.add(key);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e.getMessage(), e);
                }
            });
            return out;
        });
    }

    @Override
    @Nonnull
    public Map<K, M> removeAll(Collection<K> keys) {
        return (Map)this.mutex.lockForWriting(() -> {
            HashMap out = new HashMap();
            for (Object key : keys) {
                File file = this.fileFor(key, false);
                if (file.exists()) {
                    try {
                        out.put(key, this.cache.get(key, () -> this.read(key)));
                    }
                    catch (ExecutionException e) {
                        out.put(key, this.descriptor.builder().build());
                    }
                    finally {
                        file.delete();
                    }
                    this.cache.invalidate(key);
                    this.keyset.remove(key);
                    continue;
                }
                out.put(key, null);
            }
            return out;
        });
    }

    private Set<K> initKeySet() {
        HashSet<K> set = new HashSet<K>();
        for (String file : this.directory.list()) {
            if (!new File(this.directory, file).isFile()) continue;
            try {
                set.add(this.keyParser.apply(file));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to get key from file: " + file, e);
            }
        }
        return set;
    }

    /*
     * Exception decompiling
     */
    private M read(K key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void write(K key, M message) throws IOException {
        File tmp = this.fileFor(key, true);
        File file = this.fileFor(key, false);
        try (FileOutputStream fos = new FileOutputStream(tmp, false);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            this.serializer.serialize((OutputStream)bos, message);
            bos.flush();
        }
        catch (IOException e) {
            throw new IOException("Unable to write " + this.keyBuilder.apply(key), e);
        }
        Files.move(tmp.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private File fileFor(K key, boolean temp) {
        return new File(temp ? this.tempDir : this.directory, this.validateKey(this.keyBuilder.apply(key)));
    }

    private String validateKey(String key) {
        if (key.contains(File.separator)) {
            throw new IllegalArgumentException("Path name separator in key " + key);
        }
        return key;
    }

    @Override
    public void close() throws IOException {
        this.cache.invalidateAll();
        this.keyset.clear();
    }
}

