/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;

public interface MessageStore<K, M extends PMessage<M, F>, F extends PField> {
    @Nonnull
    public Map<K, M> getAll(@Nonnull Collection<K> var1);

    @Nonnull
    public Map<K, M> putAll(@Nonnull Map<K, M> var1);

    @Nonnull
    public Map<K, M> removeAll(Collection<K> var1);

    public boolean containsKey(@Nonnull K var1);

    @Nonnull
    public Collection<K> keys();

    @Nullable
    default public M get(@Nonnull K key) {
        return (M)((PMessage)this.getAll((Collection<K>)ImmutableList.of(key)).get(key));
    }

    @Nullable
    default public M put(@Nonnull K key, @Nonnull M message) {
        return (M)((PMessage)this.putAll((Map<K, M>)ImmutableMap.of(key, message)).get(key));
    }

    @Nullable
    default public M remove(@Nonnull K key) {
        return (M)((PMessage)this.removeAll((Collection<K>)ImmutableList.of(key)).get(key));
    }

    @Nullable
    default public <B extends PMessageBuilder<M, F>> B getBuilder(@Nonnull K key) {
        return (B)((PMessageBuilder)this.getAllBuilders((Collection<K>)ImmutableList.of(key)).get(key));
    }

    @Nonnull
    default public <B extends PMessageBuilder<M, F>> Map<K, B> getAllBuilders(@Nonnull Collection<K> keys) {
        HashMap out = new HashMap();
        this.getAll(keys).forEach((k, v) -> out.put(k, v.mutate()));
        return out;
    }

    default public <B extends PMessageBuilder<M, F>> B putBuilder(@Nonnull K key, @Nonnull B builder) {
        PMessage tmp = this.put(key, (PMessage)builder.build());
        if (tmp != null) {
            return (B)tmp.mutate();
        }
        return null;
    }

    default public <B extends PMessageBuilder<M, F>> Map<K, B> putAllBuilders(@Nonnull Map<K, B> builders) {
        HashMap instances = new HashMap();
        builders.forEach((k, b) -> {
            PMessage cfr_ignored_0 = (PMessage)instances.put(k, b.build());
        });
        Map<Object, PMessage> replaced = this.putAll(instances);
        HashMap out = new HashMap();
        replaced.forEach((k, m) -> out.put(k, m == null ? null : m.mutate()));
        return out;
    }
}

