/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.storage.MessageStore;

public class HazelcastMessageStorage<Key, Message extends PMessage<Message>>
implements MessageStore<Key, Message> {
    private final IMap<Key, Message> hazelcastMap;

    public HazelcastMessageStorage(IMap<Key, Message> hazelcastMap) {
        this.hazelcastMap = hazelcastMap;
    }

    public void putAll(@Nonnull Map<Key, Message> values) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        values.forEach((key, message) -> futureMap.put(key, this.hazelcastMap.putAsync(key, message)));
        futureMap.forEach((key, future) -> {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    public void removeAll(Collection<Key> keys) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        keys.forEach(key -> futureMap.put(key, this.hazelcastMap.removeAsync(key)));
        futureMap.forEach((key, future) -> {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    @Nonnull
    public Map<Key, Message> getAll(@Nonnull Collection<Key> keys) {
        HashMap out = new HashMap();
        this.hazelcastMap.getAll(new HashSet<Key>(keys)).forEach((key, v) -> {
            if (v != null) {
                out.put(key, v);
            }
        });
        return out;
    }

    public boolean containsKey(@Nonnull Key key) {
        return this.hazelcastMap.containsKey(key);
    }

    @Nonnull
    public Collection<Key> keys() {
        return this.hazelcastMap.keySet();
    }

    public int size() {
        return this.hazelcastMap.size();
    }
}

