/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.storage.MessageListStore;
import net.morimekta.util.collect.UnmodifiableList;

public class HazelcastMessageListStorage<K, M extends PMessage<M>>
implements MessageListStore<K, M> {
    private final IMap<K, List<M>> hazelcastMap;

    public HazelcastMessageListStorage(IMap<K, List<M>> hazelcastMap) {
        this.hazelcastMap = hazelcastMap;
    }

    public void putAll(@Nonnull Map<K, List<M>> values) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        values.forEach((key, message) -> futureMap.put(key, this.hazelcastMap.putAsync(key, new ArrayList(message))));
        futureMap.forEach((key, future) -> {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    public void removeAll(Collection<K> keys) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        keys.forEach(key -> futureMap.put(key, this.hazelcastMap.removeAsync(key)));
        futureMap.forEach((key, future) -> {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    @Nonnull
    public Map<K, List<M>> getAll(@Nonnull Collection<K> keys) {
        HashMap ret = new HashMap();
        this.hazelcastMap.getAll(new HashSet<K>(keys)).forEach((k, v) -> {
            if (v != null) {
                ret.put(k, UnmodifiableList.copyOf((Collection)v));
            }
        });
        return ret;
    }

    public boolean containsKey(@Nonnull K key) {
        return this.hazelcastMap.containsKey(key);
    }

    @Nonnull
    public Collection<K> keys() {
        return this.hazelcastMap.keySet();
    }

    public int size() {
        return this.hazelcastMap.size();
    }
}

