/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.storage.MessageStore;
import net.morimekta.providence.util.MessageUtil;

public class HazelcastMessageBuilderStorage<Key, Message extends PMessage<Message>, Builder extends PMessageBuilder<Message>>
implements MessageStore<Key, Message> {
    private final IMap<Key, Builder> hazelcastMap;

    public HazelcastMessageBuilderStorage(IMap<Key, Builder> hazelcastMap) {
        this.hazelcastMap = hazelcastMap;
    }

    public void putAll(@Nonnull Map<Key, Message> values) {
        this.putAllBuilders(MessageUtil.toBuilderValues(values));
    }

    public <B extends PMessageBuilder<Message>> void putAllBuilders(@Nonnull Map<Key, B> builders) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        builders.forEach((key, builder) -> futureMap.put(key, this.hazelcastMap.putAsync(key, builder)));
        futureMap.forEach((key, future) -> {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    @Nonnull
    public void removeAll(Collection<Key> keys) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        keys.forEach(key -> futureMap.put(key, this.hazelcastMap.removeAsync(key)));
        futureMap.forEach((key, builder) -> {
            try {
                builder.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    @Nonnull
    public Map<Key, Message> getAll(@Nonnull Collection<Key> keys) {
        return MessageUtil.toMessageValues(this.getAllBuilders(keys));
    }

    @Nonnull
    public <B extends PMessageBuilder<Message>> Map<Key, B> getAllBuilders(@Nonnull Collection<Key> keys) {
        HashMap out = new HashMap();
        this.hazelcastMap.getAll(new HashSet<Key>(keys)).forEach((key, v) -> {
            if (v != null) {
                out.put(key, v);
            }
        });
        return out;
    }

    public boolean containsKey(@Nonnull Key key) {
        return this.hazelcastMap.containsKey(key);
    }

    @Nonnull
    public Collection<Key> keys() {
        return this.hazelcastMap.keySet();
    }

    public int size() {
        return this.hazelcastMap.size();
    }
}

