/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageListStore;

public class HazelcastMessageListStorage<K, M extends PMessage<M, F>, F extends PField>
implements MessageListStore<K, M, F> {
    private final IMap<K, List<M>> hazelcastMap;

    public HazelcastMessageListStorage(IMap<K, List<M>> hazelcastMap) {
        this.hazelcastMap = hazelcastMap;
    }

    @Nonnull
    public Map<K, List<M>> putAll(@Nonnull Map<K, List<M>> values) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        values.forEach((key, message) -> futureMap.put(key, this.hazelcastMap.putAsync(key, message)));
        HashMap ret = new HashMap();
        futureMap.forEach((key, future) -> {
            try {
                List value = (List)future.get();
                if (value != null) {
                    ret.put(key, value);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return ret;
    }

    @Nonnull
    public Map<K, List<M>> removeAll(Collection<K> keys) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        keys.forEach(key -> futureMap.put(key, this.hazelcastMap.removeAsync(key)));
        HashMap ret = new HashMap();
        futureMap.forEach((key, future) -> {
            try {
                List value = (List)future.get();
                if (value != null) {
                    ret.put(key, value);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return ret;
    }

    @Nonnull
    public Map<K, List<M>> getAll(@Nonnull Collection<K> keys) {
        HashMap ret = new HashMap();
        this.hazelcastMap.getAll(new HashSet<K>(keys)).forEach((k, v) -> {
            if (v != null) {
                ret.put(k, v);
            }
        });
        return ret;
    }

    public boolean containsKey(@Nonnull K key) {
        return this.hazelcastMap.containsKey(key);
    }

    @Nonnull
    public Collection<K> keys() {
        return this.hazelcastMap.keySet();
    }
}

