/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageSetStore;

public class HazelcastMessageSetStorage<Key, Message extends PMessage<Message, Field>, Field extends PField>
implements MessageSetStore<Key, Message, Field> {
    private final IMap<Key, Message> hazelcastMap;
    private final Function<Message, Key> messageToKey;

    public HazelcastMessageSetStorage(Function<Message, Key> messageToKey, IMap<Key, Message> hazelcastMap) {
        this.messageToKey = messageToKey;
        this.hazelcastMap = hazelcastMap;
    }

    @Nonnull
    public Map<Key, Message> putAll(@Nonnull Collection<Message> values) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        values.forEach(message -> {
            Key key = this.messageToKey.apply(message);
            futureMap.put(key, this.hazelcastMap.putAsync(key, message));
        });
        HashMap ret = new HashMap();
        futureMap.forEach((key, future) -> {
            try {
                PMessage value = (PMessage)future.get();
                if (value != null) {
                    ret.put(key, value);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return ret;
    }

    @Nonnull
    public Map<Key, Message> removeAll(Collection<Key> keys) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        keys.forEach(key -> futureMap.put(key, this.hazelcastMap.removeAsync(key)));
        HashMap ret = new HashMap();
        futureMap.forEach((key, future) -> {
            try {
                PMessage value = (PMessage)future.get();
                if (value != null) {
                    ret.put(key, value);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return ret;
    }

    @Nonnull
    public Map<Key, Message> getAll(@Nonnull Collection<Key> keys) {
        HashMap out = new HashMap();
        this.hazelcastMap.getAll(new HashSet<Key>(keys)).forEach((key, v) -> {
            if (v != null) {
                out.put(key, v);
            }
        });
        return out;
    }

    public boolean containsKey(@Nonnull Key key) {
        return this.hazelcastMap.containsKey(key);
    }

    @Nonnull
    public Collection<Key> keys() {
        return this.hazelcastMap.keySet();
    }

    public int size() {
        return this.hazelcastMap.size();
    }
}

