/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageSearcher;

public class HazelcastMessageSearcher<Q, Key, M extends PMessage<M, F>, F extends PField, B extends PMessageBuilder<M, F>>
implements MessageSearcher<Q, M, F> {
    private final IMap<Key, B> hazelcastMap;
    private final Function<Q, Predicate<Key, B>> makePredicate;

    public HazelcastMessageSearcher(Function<Q, Predicate<Key, B>> makePredicate, IMap<Key, B> hazelcastMap) {
        this.makePredicate = makePredicate;
        this.hazelcastMap = hazelcastMap;
    }

    @Nonnull
    public List<M> search(@Nonnull Q query) {
        return this.stream(query).collect(Collectors.toList());
    }

    public Stream<M> stream(@Nonnull Q query) {
        return this.hazelcastMap.values(this.makePredicate.apply(query)).stream().map(PBuilder::build);
    }
}

