/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.storage.hazelcast;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.storage.MessageStore;

public class HazelcastMessageBuilderStorage<Key, Message extends PMessage<Message, Field>, Field extends PField, Builder extends PMessageBuilder<Message, Field>>
implements MessageStore<Key, Message, Field> {
    private final IMap<Key, Builder> hazelcastMap;

    public HazelcastMessageBuilderStorage(IMap<Key, Builder> hazelcastMap) {
        this.hazelcastMap = hazelcastMap;
    }

    @Nonnull
    public Map<Key, Message> putAll(@Nonnull Map<Key, Message> values) {
        HashMap tmpIn = new HashMap();
        values.forEach((key, message) -> tmpIn.put(key, message.mutate()));
        Map<Object, PMessageBuilder> tmpOut = this.putAllBuilders(tmpIn);
        HashMap ret = new HashMap();
        tmpOut.forEach((key, builder) -> ret.put(key, (PMessage)builder.build()));
        return ret;
    }

    @Nonnull
    public <B extends PMessageBuilder<Message, Field>> Map<Key, B> putAllBuilders(@Nonnull Map<Key, B> builders) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        builders.forEach((key, builder) -> futureMap.put(key, this.hazelcastMap.putAsync(key, builder)));
        HashMap ret = new HashMap();
        futureMap.forEach((key, future) -> {
            try {
                PMessageBuilder value = (PMessageBuilder)future.get();
                if (value != null) {
                    ret.put(key, value);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return ret;
    }

    @Nonnull
    public Map<Key, Message> removeAll(Collection<Key> keys) {
        HashMap<Object, ICompletableFuture> futureMap = new HashMap<Object, ICompletableFuture>();
        keys.forEach(key -> futureMap.put(key, this.hazelcastMap.removeAsync(key)));
        HashMap ret = new HashMap();
        futureMap.forEach((key, builder) -> {
            try {
                PMessageBuilder value = (PMessageBuilder)builder.get();
                if (value != null) {
                    ret.put(key, (PMessage)value.build());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return ret;
    }

    @Nonnull
    public Map<Key, Message> getAll(@Nonnull Collection<Key> keys) {
        HashMap ret = new HashMap();
        this.getAllBuilders(keys).forEach((key, builder) -> ret.put(key, (PMessage)builder.build()));
        return ret;
    }

    @Nonnull
    public <B extends PMessageBuilder<Message, Field>> Map<Key, B> getAllBuilders(@Nonnull Collection<Key> keys) {
        HashMap out = new HashMap();
        this.hazelcastMap.getAll(new HashSet<Key>(keys)).forEach((key, v) -> {
            if (v != null) {
                out.put(key, v);
            }
        });
        return out;
    }

    public boolean containsKey(@Nonnull Key key) {
        return this.hazelcastMap.containsKey(key);
    }

    @Nonnull
    public Collection<Key> keys() {
        return this.hazelcastMap.keySet();
    }

    public int size() {
        return this.hazelcastMap.size();
    }
}

