/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.json;

import java.io.OutputStream;
import net.morimekta.util.Binary;
import net.morimekta.util.io.IndentedPrintWriter;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonWriter;

public class PrettyJsonWriter
extends JsonWriter {
    private static final int SPACE = 32;
    private final IndentedPrintWriter writer;

    public PrettyJsonWriter(OutputStream out) {
        this(new IndentedPrintWriter(out));
    }

    public PrettyJsonWriter(IndentedPrintWriter writer) {
        super(writer);
        this.writer = writer;
    }

    @Override
    public PrettyJsonWriter object() throws JsonException {
        super.object();
        this.writer.begin();
        return this;
    }

    @Override
    public PrettyJsonWriter array() throws JsonException {
        super.array();
        this.writer.begin();
        return this;
    }

    @Override
    public PrettyJsonWriter endObject() throws JsonException {
        this.writer.end();
        if (this.context.num != 0) {
            this.writer.appendln();
        }
        super.endObject();
        return this;
    }

    @Override
    public PrettyJsonWriter endArray() throws JsonException {
        this.writer.end();
        if (this.context.num != 0) {
            this.writer.appendln();
        }
        super.endArray();
        return this;
    }

    @Override
    public PrettyJsonWriter key(boolean key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(byte key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(short key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(int key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(long key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(double key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(CharSequence key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter key(Binary key) throws JsonException {
        super.key(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter keyLiteral(CharSequence key) throws JsonException {
        super.keyLiteral(key);
        this.writer.write(32);
        return this;
    }

    @Override
    public PrettyJsonWriter value(boolean value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(byte value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(short value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(int value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(long value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(double value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(CharSequence value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter value(Binary value) throws JsonException {
        super.value(value);
        return this;
    }

    @Override
    public PrettyJsonWriter valueLiteral(CharSequence value) throws JsonException {
        super.valueLiteral(value);
        return this;
    }

    @Override
    protected void startKey() throws JsonException {
        super.startKey();
        this.writer.appendln();
    }

    @Override
    protected boolean startValue() throws JsonException {
        if (super.startValue()) {
            this.writer.appendln();
            return true;
        }
        return false;
    }
}

