/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import net.morimekta.util.io.Utf8StreamReader;

public class IOUtils {
    private static final int BUF_SIZE = 4096;

    public static boolean skipUntil(InputStream in, byte[] separator) throws IOException {
        if (separator == null) {
            throw new NullPointerException("Null separator given");
        }
        int len = separator.length;
        if (len > 0) {
            int r;
            if (len == 1) {
                return IOUtils.skipUntil(in, separator[0]);
            }
            if (len > 4) {
                return IOUtils.skipUntilInternal(in, separator, new byte[len]);
            }
            int mask = len == 2 ? 65535 : (len == 3 ? 0xFFFFFF : -1);
            int sep = separator[0] % 256 << 8 | separator[1];
            if (len > 2) {
                sep = sep << 8 | separator[2];
            }
            if (len > 3) {
                sep = sep << 8 | separator[3];
            }
            int p = 0;
            int tmp = 0;
            while ((r = in.read()) >= 0) {
                tmp = tmp << 8 | r;
                if (++p < len || (tmp & mask) != sep) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean skipUntil(InputStream in, byte separator) throws IOException {
        int r;
        while ((r = in.read()) >= 0) {
            if ((byte)r != separator) continue;
            return true;
        }
        return false;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int r;
        byte[] buffer = new byte[4096];
        while ((r = in.read(buffer)) >= 0) {
            out.write(buffer, 0, r);
        }
    }

    public static String readString(InputStream is) throws IOException {
        return IOUtils.readString((Reader)new Utf8StreamReader(is), '\u0000');
    }

    public static String readString(InputStream is, String term) throws IOException {
        return IOUtils.readString((Reader)new Utf8StreamReader(is), term);
    }

    public static String readString(Reader is) throws IOException {
        return IOUtils.readString(is, '\u0000');
    }

    public static String readString(Reader is, char term) throws IOException {
        char ch;
        int ch_int;
        CharArrayWriter baos = new CharArrayWriter();
        while ((ch_int = is.read()) >= 0 && (ch = (char)ch_int) != term) {
            baos.write(ch);
        }
        return baos.toString();
    }

    public static String readString(Reader is, String term) throws IOException {
        int ch_int;
        CharArrayWriter baos = new CharArrayWriter();
        char last = term.charAt(term.length() - 1);
        while ((ch_int = is.read()) >= 0) {
            String tmp;
            char ch = (char)ch_int;
            baos.write(ch);
            if (ch != last || baos.size() < term.length() || !(tmp = baos.toString()).substring(tmp.length() - term.length()).equals(term)) continue;
            return tmp.substring(0, tmp.length() - term.length());
        }
        return baos.toString();
    }

    private IOUtils() {
    }

    private static boolean skipUntilInternal(InputStream in, byte[] separator, byte[] buffer) throws IOException {
        int r;
        int l = 0;
        while ((r = in.read()) >= 0) {
            System.arraycopy(buffer, 1, buffer, 0, buffer.length - 1);
            buffer[buffer.length - 1] = (byte)r;
            if (++l < buffer.length || !Arrays.equals(separator, buffer)) continue;
            return true;
        }
        return false;
    }
}

