/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private final OutputStream mOut;
    private int mByteCount;

    public CountingOutputStream(OutputStream out) {
        this.mOut = out;
        this.mByteCount = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.mOut.write(b);
        ++this.mByteCount;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.mOut.write(bytes);
        this.mByteCount += bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.mOut.write(bytes, off, len);
        this.mByteCount += len;
    }

    @Override
    public void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.mOut.close();
    }

    public int getByteCount() {
        return this.mByteCount;
    }
}

