/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util.io;

import java.io.IOException;
import java.io.OutputStream;
import net.morimekta.util.Binary;

public class BinaryWriter
extends OutputStream {
    protected final OutputStream out;

    public BinaryWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.out.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.out.write(bytes, off, len);
    }

    @Override
    public void close() {
    }

    public int writeByte(byte integer) throws IOException {
        this.out.write(integer);
        return 1;
    }

    public int writeShort(short integer) throws IOException {
        this.out.write(integer);
        this.out.write(integer >>> 8);
        return 2;
    }

    public int writeInt(int integer) throws IOException {
        this.out.write(integer);
        this.out.write(integer >>> 8);
        this.out.write(integer >>> 16);
        this.out.write(integer >>> 24);
        return 4;
    }

    public int writeLong(long integer) throws IOException {
        this.out.write((int)integer);
        this.out.write((int)(integer >>> 8));
        this.out.write((int)(integer >>> 16));
        this.out.write((int)(integer >>> 24));
        this.out.write((int)(integer >>> 32));
        this.out.write((int)(integer >>> 40));
        this.out.write((int)(integer >>> 48));
        this.out.write((int)(integer >>> 56));
        return 8;
    }

    public int writeDouble(double value) throws IOException {
        return this.writeLong(Double.doubleToLongBits(value));
    }

    public int writeBinary(Binary value) throws IOException {
        return value.write(this.out);
    }

    public int writeUInt8(int number) throws IOException {
        this.out.write(number);
        return 1;
    }

    public int writeUInt16(int number) throws IOException {
        this.out.write(number);
        this.out.write(number >>> 8);
        return 2;
    }

    public int writeUInt24(int number) throws IOException {
        this.out.write(number);
        this.out.write(number >>> 8);
        this.out.write(number >>> 16);
        return 3;
    }

    public int writeUInt32(int number) throws IOException {
        this.out.write(number);
        this.out.write(number >>> 8);
        this.out.write(number >>> 16);
        this.out.write(number >>> 24);
        return 4;
    }

    public int writeUnsigned(int number, int bytes) throws IOException {
        switch (bytes) {
            case 4: {
                return this.writeUInt32(number);
            }
            case 3: {
                return this.writeUInt24(number);
            }
            case 2: {
                return this.writeUInt16(number);
            }
            case 1: {
                return this.writeUInt8(number);
            }
        }
        throw new IllegalArgumentException("Unsupported byte count for unsigned: " + bytes);
    }

    public int writeSigned(int number, int bytes) throws IOException {
        switch (bytes) {
            case 8: {
                return this.writeLong(number);
            }
            case 4: {
                return this.writeInt(number);
            }
            case 2: {
                return this.writeShort((short)number);
            }
            case 1: {
                return this.writeByte((byte)number);
            }
        }
        throw new IllegalArgumentException("Unsupported byte count for signed: " + bytes);
    }

    public int writeSigned(long number, int bytes) throws IOException {
        switch (bytes) {
            case 8: {
                return this.writeLong(number);
            }
            case 4: {
                return this.writeInt((int)number);
            }
            case 2: {
                return this.writeShort((short)number);
            }
            case 1: {
                return this.writeByte((byte)number);
            }
        }
        throw new IllegalArgumentException("Unsupported byte count for signed: " + bytes);
    }

    public int writeZigzag(int number) throws IOException {
        return this.writeVarint(number << 1 ^ number >> 31);
    }

    public int writeZigzag(long number) throws IOException {
        return this.writeVarint(number << 1 ^ number >> 63);
    }

    public int writeVarint(int varint) throws IOException {
        int b = 1;
        boolean c = (varint ^ varint & 0x7F) != 0;
        this.out.write((c ? 128 : 0) | varint & 0x7F);
        while (c) {
            ++b;
            c = ((varint >>>= 7) ^ varint & 0x7F) != 0;
            this.out.write((c ? 128 : 0) | varint & 0x7F);
        }
        return b;
    }

    public int writeVarint(long varint) throws IOException {
        int b = 1;
        boolean c = (varint ^ varint & 0x7FL) != 0L;
        this.out.write((c ? 128 : 0) | (int)(varint & 0x7FL));
        while (c) {
            ++b;
            c = ((varint >>>= 7) ^ varint & 0x7FL) != 0L;
            this.out.write((c ? 128 : 0) | (int)(varint & 0x7FL));
        }
        return b;
    }
}

