/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.util;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.morimekta.util.Numeric;
import net.morimekta.util.Stringable;

public class Strings {
    private static final String NULL = "null";
    private static final Pattern INT = Pattern.compile("-?[0-9]+");

    public static String escape(CharSequence string) {
        StringBuilder builder = new StringBuilder();
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    builder.append('\\').append('b');
                    continue block9;
                }
                case '\t': {
                    builder.append('\\').append('t');
                    continue block9;
                }
                case '\n': {
                    builder.append('\\').append('n');
                    continue block9;
                }
                case '\f': {
                    builder.append('\\').append('f');
                    continue block9;
                }
                case '\r': {
                    builder.append('\\').append('r');
                    continue block9;
                }
                case '\"': 
                case '\'': {
                    builder.append('\\').append(c);
                    continue block9;
                }
                case '\\': {
                    builder.append('\\').append('\\');
                    continue block9;
                }
                default: {
                    if (c < ' ' || c == '\u007f') {
                        builder.append(String.format("\\%03o", c));
                        continue block9;
                    }
                    if ('\u007f' < c && c < '\u00a0' || '\u2000' <= c && c < '\u2100' || !Character.isDefined(c)) {
                        builder.append(String.format("\\u%04x", c));
                        continue block9;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static String unescapeForEncodeUriCompatability(String str) {
        return str.replace("%21", "!").replace("%7E", "~").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%3B", ";").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%2B", "+").replace("%24", "$").replace("%2C", ",").replace("%23", "#");
    }

    public static String join(String delimiter, Object ... values) {
        if (values.length == 1) {
            Class<?> type = values[0].getClass();
            if (char[].class.equals(type)) {
                return Strings.joinP(delimiter, (char[])values[0]);
            }
            if (int[].class.equals(type)) {
                return Strings.joinP(delimiter, (int[])values[0]);
            }
            if (long[].class.equals(type)) {
                return Strings.joinP(delimiter, (long[])values[0]);
            }
            if (double[].class.equals(type)) {
                return Strings.joinP(delimiter, (double[])values[0]);
            }
            if (boolean[].class.equals(type)) {
                return Strings.joinP(delimiter, (boolean[])values[0]);
            }
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object value : values) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(Objects.toString(value));
        }
        return builder.toString();
    }

    public static String joinP(String delimiter, char ... chars) {
        StringBuilder builder = new StringBuilder(chars.length + delimiter.length() * chars.length);
        boolean first = true;
        for (char c : chars) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String joinP(String delimiter, int ... values) {
        StringBuilder builder = new StringBuilder(values.length + delimiter.length() * values.length);
        boolean first = true;
        for (int i : values) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(Integer.toString(i));
        }
        return builder.toString();
    }

    public static String joinP(String delimiter, long ... values) {
        StringBuilder builder = new StringBuilder(values.length + delimiter.length() * values.length);
        boolean first = true;
        for (long i : values) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(Long.toString(i));
        }
        return builder.toString();
    }

    public static String joinP(String delimiter, double ... values) {
        StringBuilder builder = new StringBuilder(values.length + delimiter.length() * values.length);
        boolean first = true;
        for (double d : values) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(Strings.asString(d));
        }
        return builder.toString();
    }

    public static String joinP(String delimiter, boolean ... values) {
        StringBuilder builder = new StringBuilder(values.length + delimiter.length() * values.length);
        boolean first = true;
        for (boolean d : values) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(d);
        }
        return builder.toString();
    }

    public static <T> String join(String delimiter, Collection<T> strings) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (T o : strings) {
            if (first) {
                first = false;
            } else {
                builder.append(delimiter);
            }
            builder.append(Objects.toString(o));
        }
        return builder.toString();
    }

    public static boolean isInteger(String key) {
        return INT.matcher(key).matches();
    }

    public static String times(String s, int num) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            builder.append(s);
        }
        return builder.toString();
    }

    public static String camelCase(String prefix, String name) {
        String[] parts;
        StringBuilder builder = new StringBuilder();
        builder.append(prefix);
        for (String part : parts = name.split("[-._]")) {
            if (part.isEmpty()) continue;
            builder.append(Strings.capitalize(part));
        }
        return builder.toString();
    }

    public static String c_case(String prefix, String name, String suffix) {
        StringBuilder builder = new StringBuilder(prefix.length() + name.length() + 5);
        builder.append(prefix);
        boolean lastUpper = true;
        for (char c : name.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!lastUpper) {
                    builder.append('_');
                }
                lastUpper = true;
            } else {
                if (c == '_' || c == '.' || c == '-') {
                    builder.append('_');
                    lastUpper = true;
                    continue;
                }
                lastUpper = false;
            }
            builder.append(Character.toLowerCase(c));
        }
        builder.append(suffix);
        return builder.toString();
    }

    public static String c_case(String prefix, String name) {
        return Strings.c_case(prefix, name, "");
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String asString(double d) {
        long l = (long)d;
        if (d > 5119.0 || 1.0 / d > 640.0) {
            return new DecimalFormat("0.#########E0").format(d);
        }
        if (d == (double)l) {
            return Long.toString(l);
        }
        return Double.toString(d);
    }

    public static String asString(Collection<?> collection) {
        if (collection == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        boolean first = true;
        for (Object item : collection) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(Strings.asString(item));
        }
        builder.append(']');
        return builder.toString();
    }

    public static String asString(Map<?, ?> map) {
        if (map == null) {
            return NULL;
        }
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(Strings.asString(entry.getKey())).append(':').append(Strings.asString(entry.getValue()));
        }
        builder.append('}');
        return builder.toString();
    }

    public static String asString(Object o) {
        if (o == null) {
            return NULL;
        }
        if (o instanceof Stringable) {
            return ((Stringable)o).asString();
        }
        if (o instanceof Numeric) {
            return String.format("%d", ((Numeric)o).asInteger());
        }
        if (o instanceof CharSequence) {
            return String.format("\"%s\"", Strings.escape((CharSequence)o));
        }
        if (o instanceof Double) {
            return Strings.asString((Double)o);
        }
        if (o instanceof Collection) {
            return Strings.asString((Collection)o);
        }
        if (o instanceof Map) {
            return Strings.asString((Map)o);
        }
        return o.toString();
    }

    public static int commonPrefix(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public static int commonSuffix(String text1, String text2) {
        int text1_length = text1.length();
        int text2_length = text2.length();
        int n = Math.min(text1_length, text2_length);
        for (int i = 1; i <= n; ++i) {
            if (text1.charAt(text1_length - i) == text2.charAt(text2_length - i)) continue;
            return i - 1;
        }
        return n;
    }

    public static int commonOverlap(String text1, String text2) {
        int text1_length = text1.length();
        int text2_length = text2.length();
        if (text1_length == 0 || text2_length == 0) {
            return 0;
        }
        if (text1_length > text2_length) {
            text1 = text1.substring(text1_length - text2_length);
        } else if (text1_length < text2_length) {
            text2 = text2.substring(0, text1_length);
        }
        int text_length = Math.min(text1_length, text2_length);
        if (text1.equals(text2)) {
            return text_length;
        }
        int best = 0;
        int length = 1;
        String pattern;
        int found;
        while ((found = text2.indexOf(pattern = text1.substring(text_length - length))) != -1) {
            if (found != 0 && !text1.substring(text_length - (length += found)).equals(text2.substring(0, length))) continue;
            best = length++;
        }
        return best;
    }

    private Strings() {
    }
}

