/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.thrift.transport.TFramedTransport;

public class FramedBufferOutputStream
extends OutputStream {
    private static final int MAX_BUFFER_SIZE = 0xFA0000;
    private final byte[] frameSizeBuffer;
    private final ByteBuffer buffer;
    private final WritableByteChannel out;

    public FramedBufferOutputStream(WritableByteChannel out) {
        this.out = out;
        this.frameSizeBuffer = new byte[4];
        this.buffer = ByteBuffer.allocateDirect(0xFA0000);
        this.buffer.limit(0xFA0000);
    }

    @Override
    public void write(int val) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.flush();
        }
        this.buffer.put((byte)val);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this.buffer.remaining() < bytes.length) {
            this.flush();
        }
        this.buffer.put(bytes);
    }

    @Override
    public void write(byte[] var1, int off, int len) throws IOException {
        if (this.buffer.remaining() < len) {
            this.flush();
        }
        this.buffer.put(var1, off, off);
    }

    @Override
    public void flush() throws IOException {
        int frameSize = this.buffer.position();
        if (frameSize > 0) {
            TFramedTransport.encodeFrameSize(frameSize, this.frameSizeBuffer);
            this.out.write(ByteBuffer.wrap(this.frameSizeBuffer));
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                this.out.write(this.buffer);
            }
            this.buffer.rewind();
            this.buffer.limit(0xFA0000);
        }
    }
}

