/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.thrift.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.thrift.transport.TFramedTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramedBufferInputSteram
extends InputStream {
    private static Logger LOGGER = LoggerFactory.getLogger(FramedBufferInputSteram.class.getName());
    private static final int MAX_BUFFER_SIZE = 0xFA0000;
    private final ByteBuffer frameSizeBuffer;
    private final ReadableByteChannel in;
    private final ByteBuffer buffer;

    public FramedBufferInputSteram(ReadableByteChannel in) {
        this.in = in;
        this.frameSizeBuffer = ByteBuffer.allocate(4);
        this.buffer = ByteBuffer.allocateDirect(0xFA0000);
        this.buffer.limit(0);
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && this.readFrame() < 0) {
            return -1;
        }
        return FramedBufferInputSteram.intValue(this.buffer.get());
    }

    private static int intValue(byte b) {
        if (b < 0) {
            return b + 256;
        }
        return b;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        int pos;
        int remaining;
        if (off < 0 || len < 0) {
            throw new IOException();
        }
        if (off + len > data.length) {
            throw new IOException();
        }
        for (pos = 0; pos < len; pos += remaining) {
            if (!this.buffer.hasRemaining() && this.readFrame() < 0) {
                return pos;
            }
            remaining = this.buffer.remaining();
            this.buffer.get(data, off + pos, Math.min(len - pos, remaining));
        }
        return pos;
    }

    private int readFrame() throws IOException {
        this.frameSizeBuffer.rewind();
        this.frameSizeBuffer.limit(4);
        this.in.read(this.frameSizeBuffer);
        if (this.frameSizeBuffer.position() == 0) {
            return -1;
        }
        if (this.frameSizeBuffer.position() < 4) {
            throw new IOException();
        }
        int frameSize = TFramedTransport.decodeFrameSize(this.frameSizeBuffer.array());
        if (frameSize < 1 || frameSize > 0xFA0000) {
            throw new IOException();
        }
        this.buffer.rewind();
        this.buffer.limit(frameSize);
        while (this.in.read(this.buffer) > 0 && this.buffer.position() != frameSize) {
            LOGGER.debug("still not enough:  " + this.buffer.position() + " of " + frameSize);
        }
        if (this.buffer.position() < frameSize) {
            throw new IOException();
        }
        this.buffer.flip();
        return frameSize;
    }
}

