/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PBuilder;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.PServiceCallType;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.serializer.ApplicationException;
import net.morimekta.providence.serializer.ApplicationExceptionType;
import net.morimekta.providence.serializer.Serializer;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Binary;
import net.morimekta.util.io.BigEndianBinaryReader;
import net.morimekta.util.io.BigEndianBinaryWriter;
import net.morimekta.util.io.BinaryReader;
import net.morimekta.util.io.BinaryWriter;

public class BinarySerializer
extends Serializer {
    public static final String MIME_TYPE = "application/vnd.apache.thrift.binary";
    private static final int VERSION_MASK = -65536;
    private static final int VERSION_1 = -2147418112;
    private final boolean readStrict;
    private final boolean versioned;

    public BinarySerializer() {
        this(true);
    }

    public BinarySerializer(boolean readStrict) {
        this(readStrict, true);
    }

    public BinarySerializer(boolean readStrict, boolean versioned) {
        this.readStrict = readStrict;
        this.versioned = versioned;
    }

    @Override
    public boolean binaryProtocol() {
        return true;
    }

    @Override
    public String mimeType() {
        return MIME_TYPE;
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream os, Message message) throws IOException, SerializerException {
        BigEndianBinaryWriter writer = new BigEndianBinaryWriter(os);
        return this.writeMessage(writer, message);
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> int serialize(OutputStream os, PServiceCall<Message, Field> call) throws IOException, SerializerException {
        BigEndianBinaryWriter out = new BigEndianBinaryWriter(os);
        byte[] method = call.getMethod().getBytes(StandardCharsets.UTF_8);
        int len = method.length;
        if (this.versioned) {
            len += ((BinaryWriter)out).writeInt(0x80010000 | (byte)call.getType().key);
            len += ((BinaryWriter)out).writeInt(method.length);
            out.write(method);
        } else {
            len += ((BinaryWriter)out).writeInt(method.length);
            out.write(method);
            len += out.writeByte((byte)call.getType().key);
        }
        len += ((BinaryWriter)out).writeInt(call.getSequence());
        return len += this.writeMessage(out, call.getMessage());
    }

    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> Message deserialize(InputStream input, PStructDescriptor<Message, Field> descriptor) throws SerializerException, IOException {
        BigEndianBinaryReader reader = new BigEndianBinaryReader(input);
        return this.readMessage(reader, descriptor, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <Message extends PMessage<Message, Field>, Field extends PField> PServiceCall<Message, Field> deserialize(InputStream is, PService service) throws SerializerException {
        BigEndianBinaryReader in = new BigEndianBinaryReader(is);
        String methodName = null;
        int sequence = 0;
        PServiceCallType type = null;
        try {
            int typeKey;
            int methodNameLen = in.expectInt();
            if (methodNameLen < 0) {
                int version = methodNameLen & 0xFFFF0000;
                if (version != -2147418112) throw new SerializerException("Bad protocol version: %08x", version >>> 16);
                typeKey = methodNameLen & 0xFF;
                methodNameLen = in.expectInt();
                methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
            } else {
                if (this.readStrict && this.versioned) {
                    throw new SerializerException("Missing protocol version", new Object[0]);
                }
                methodName = new String(in.expectBytes(methodNameLen), StandardCharsets.UTF_8);
                typeKey = in.expectByte();
            }
            sequence = in.expectInt();
            type = PServiceCallType.findByKey(typeKey);
            PServiceMethod method = service.getMethod(methodName);
            if (type == null) {
                throw new SerializerException("Invalid call type " + typeKey, new Object[0]).setExceptionType(ApplicationExceptionType.INVALID_MESSAGE_TYPE).setMethodName(methodName).setSequenceNo(sequence);
            }
            if (type == PServiceCallType.EXCEPTION) {
                ApplicationException ex = this.readMessage(in, ApplicationException.kDescriptor, false);
                return new PServiceCall(methodName, type, sequence, ex);
            }
            if (method == null) {
                throw new SerializerException("No such method " + methodName + " on " + service.getQualifiedName(null), new Object[0]).setExceptionType(ApplicationExceptionType.UNKNOWN_METHOD).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
            }
            try {
                PStructDescriptor descriptor = type.request ? method.getRequestType() : method.getResponseType();
                Message message = this.readMessage(in, descriptor, false);
                return new PServiceCall(methodName, type, sequence, message);
            }
            catch (SerializerException se) {
                throw new SerializerException(se, se.getMessage(), new Object[0]).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
            }
        }
        catch (IOException e) {
            throw new SerializerException(e, e.getMessage(), new Object[0]).setExceptionType(ApplicationExceptionType.PROTOCOL_ERROR).setMethodName(methodName).setCallType(type).setSequenceNo(sequence);
        }
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> int writeMessage(BinaryWriter writer, Message message) throws IOException, SerializerException {
        int len = 0;
        if (message instanceof PUnion) {
            Object field = ((PUnion)message).unionField();
            if (field != null) {
                len += this.writeFieldSpec(writer, field.getDescriptor().getType().id, field.getKey());
                len += this.writeFieldValue(writer, message.get(field.getKey()), field.getDescriptor());
            }
        } else {
            for (PField field : message.descriptor().getFields()) {
                if (!message.has(field.getKey())) continue;
                len += this.writeFieldSpec(writer, field.getDescriptor().getType().id, field.getKey());
                len += this.writeFieldValue(writer, message.get(field.getKey()), field.getDescriptor());
            }
        }
        return len += writer.writeUInt8(PType.STOP.id);
    }

    private <Message extends PMessage<Message, Field>, Field extends PField> Message readMessage(BinaryReader input, PStructDescriptor<Message, Field> descriptor, boolean nullable) throws SerializerException, IOException {
        FieldInfo fieldInfo = this.readFieldInfo(input);
        if (nullable && fieldInfo == null) {
            return null;
        }
        PBuilder builder = descriptor.builder();
        while (fieldInfo != null) {
            Field field = descriptor.getField(fieldInfo.getId());
            if (field != null) {
                Object value = this.readFieldValue(input, fieldInfo, field.getDescriptor());
                ((PMessageBuilder)builder).set(field.getKey(), value);
            } else {
                if (this.readStrict) {
                    throw new SerializerException("Unknown field " + fieldInfo.getId() + " for type" + descriptor.getQualifiedName(null), new Object[0]);
                }
                this.readFieldValue(input, fieldInfo, null);
            }
            fieldInfo = this.readFieldInfo(input);
        }
        return (Message)((PMessage)builder.build());
    }

    private void consumeMessage(BinaryReader in) throws IOException, SerializerException {
        FieldInfo fieldInfo;
        while ((fieldInfo = this.readFieldInfo(in)) != null) {
            this.readFieldValue(in, fieldInfo, null);
        }
    }

    private FieldInfo readFieldInfo(BinaryReader in) throws IOException, SerializerException {
        byte type = in.expectByte();
        if (type == PType.STOP.id) {
            return null;
        }
        return new FieldInfo(in.expectUInt16(), type);
    }

    private <Type> Type readFieldValue(BinaryReader in, FieldInfo fieldInfo, PDescriptor type) throws IOException, SerializerException {
        if (type == null) {
            if (this.readStrict) {
                throw new SerializerException("Reading unknown field in strict mode.", new Object[0]);
            }
        } else if (type.getType().id != fieldInfo.getType()) {
            if (this.readStrict) {
                throw new SerializerException("Mismatching field type in strict mode.", new Object[0]);
            }
            this.readFieldValue(in, fieldInfo, null);
            return null;
        }
        switch (PType.findById(fieldInfo.getType())) {
            case VOID: {
                return this.cast(Boolean.FALSE);
            }
            case BOOL: {
                return this.cast(in.expectByte() != 0);
            }
            case BYTE: {
                return this.cast(in.expectByte());
            }
            case I16: {
                return this.cast(in.expectShort());
            }
            case ENUM: 
            case I32: {
                int val = in.expectInt();
                if (type != null && type instanceof PEnumDescriptor) {
                    PBuilder builder = ((PEnumDescriptor)type).builder();
                    ((PEnumBuilder)builder).setByValue(val);
                    return this.cast(builder.build());
                }
                return this.cast(val);
            }
            case I64: {
                return this.cast(in.expectLong());
            }
            case DOUBLE: {
                return this.cast(in.expectDouble());
            }
            case STRING: 
            case BINARY: {
                int len = in.expectUInt32();
                byte[] data = in.expectBytes(len);
                if (type != null && type.getType() == PType.STRING) {
                    return this.cast(new String(data, StandardCharsets.UTF_8));
                }
                return this.cast(Binary.wrap(data));
            }
            case MESSAGE: {
                if (type == null) {
                    this.consumeMessage(in);
                    return null;
                }
                return this.cast(this.readMessage(in, (PStructDescriptor)type, false));
            }
            case MAP: {
                PBuilder<Map<Type, Type>> out;
                byte keyT = in.expectByte();
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor keyType = null;
                PDescriptor valueType = null;
                if (type != null) {
                    if (!type.getType().equals((Object)PType.MAP)) {
                        throw new SerializerException("Invalid type for map encoding: " + type, new Object[0]);
                    }
                    PMap mapType = (PMap)type;
                    keyType = mapType.keyDescriptor();
                    valueType = mapType.itemDescriptor();
                    out = mapType.builder();
                } else {
                    out = new PMap.ImmutableMapBuilder();
                }
                FieldInfo keyInfo = new FieldInfo(1, keyT);
                FieldInfo itemInfo = new FieldInfo(2, itemT);
                for (int i = 0; i < size; ++i) {
                    Type key = this.readFieldValue(in, keyInfo, keyType);
                    Type value = this.readFieldValue(in, itemInfo, valueType);
                    if (key != null && value != null) {
                        out.put(key, value);
                        continue;
                    }
                    if (!this.readStrict) continue;
                    throw new SerializerException("Null key or value in map.", new Object[0]);
                }
                return this.cast(out.build());
            }
            case SET: {
                PBuilder<Set<Type>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (type != null) {
                    PSet setType = (PSet)type;
                    entryType = setType.itemDescriptor();
                    out = setType.builder();
                } else {
                    out = new PSet.ImmutableSetBuilder();
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    Type key = this.readFieldValue(in, itemInfo, entryType);
                    if (key != null) {
                        out.add(key);
                        continue;
                    }
                    if (!this.readStrict) continue;
                    throw new SerializerException("Null value in set.", new Object[0]);
                }
                return this.cast(out.build());
            }
            case LIST: {
                PBuilder<List<Type>> out;
                byte itemT = in.expectByte();
                int size = in.expectUInt32();
                PDescriptor entryType = null;
                if (type != null) {
                    PList listType = (PList)type;
                    entryType = listType.itemDescriptor();
                    out = listType.builder();
                } else {
                    out = new PList.ImmutableListBuilder();
                }
                FieldInfo itemInfo = new FieldInfo(0, itemT);
                for (int i = 0; i < size; ++i) {
                    Type key = this.readFieldValue(in, itemInfo, entryType);
                    if (key != null) {
                        out.add(key);
                        continue;
                    }
                    if (!this.readStrict) continue;
                    throw new SerializerException("Null value in list.", new Object[0]);
                }
                return this.cast(out.build());
            }
        }
        throw new SerializerException("unknown data type: " + fieldInfo.getType(), new Object[0]);
    }

    private int writeFieldSpec(BinaryWriter out, byte type, int key) throws IOException {
        out.writeByte(type);
        out.writeUInt16(key);
        return 3;
    }

    private int writeFieldValue(BinaryWriter out, Object value, PDescriptor descriptor) throws IOException, SerializerException {
        switch (descriptor.getType()) {
            case BOOL: {
                return out.writeByte((Boolean)value != false ? (byte)1 : 0);
            }
            case BYTE: {
                return out.writeByte((Byte)value);
            }
            case I16: {
                return out.writeShort((Short)value);
            }
            case I32: {
                return out.writeInt((Integer)value);
            }
            case I64: {
                return out.writeLong((Long)value);
            }
            case DOUBLE: {
                return out.writeDouble((Double)value);
            }
            case BINARY: {
                Binary binary = (Binary)value;
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case STRING: {
                Binary binary = Binary.wrap(value.toString().getBytes(StandardCharsets.UTF_8));
                int len = out.writeUInt32(binary.length());
                return len + out.writeBinary(binary);
            }
            case ENUM: {
                return out.writeInt(((PEnumValue)value).getValue());
            }
            case MAP: {
                Map map = (Map)value;
                PMap pMap = (PMap)descriptor;
                int len = out.writeByte(pMap.keyDescriptor().getType().id);
                len += out.writeByte(pMap.itemDescriptor().getType().id);
                len += out.writeUInt32(map.size());
                for (Map.Entry entry : map.entrySet()) {
                    len += this.writeFieldValue(out, entry.getKey(), pMap.keyDescriptor());
                    len += this.writeFieldValue(out, entry.getValue(), pMap.itemDescriptor());
                }
                return len;
            }
            case SET: 
            case LIST: {
                Collection coll = (Collection)value;
                PContainer pSet = (PContainer)descriptor;
                int len = out.writeByte(pSet.itemDescriptor().getType().id);
                len += out.writeUInt32(coll.size());
                for (Object item : coll) {
                    len += this.writeFieldValue(out, item, pSet.itemDescriptor());
                }
                return len;
            }
            case MESSAGE: {
                int size = this.writeMessage(out, (PMessage)value);
                return size;
            }
        }
        throw new SerializerException("", new Object[0]);
    }

    private static class FieldInfo {
        private final int id;
        private final byte type;

        private FieldInfo(int id, byte type) {
            this.id = id;
            this.type = type;
        }

        public String toString() {
            return String.format("field(%d: %s)", new Object[]{this.id, PType.findById(this.type)});
        }

        public int getId() {
            return this.id;
        }

        public byte getType() {
            return this.type;
        }
    }
}

