/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.rpc.options;

import java.io.File;
import java.nio.file.Path;
import net.morimekta.providence.rpc.options.Format;

public class ConvertStream {
    public final Format format;
    public final File file;

    public ConvertStream(Format format, File file) {
        this.format = format;
        this.file = file;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean hasFormat = false;
        if (this.format != null) {
            hasFormat = true;
            builder.append(this.format.name());
        }
        if (this.file != null) {
            if (hasFormat) {
                builder.append(',');
            }
            Path pwd = new File(System.getenv("PWD")).getAbsoluteFile().toPath();
            String abs = this.file.getAbsolutePath();
            String rel = pwd.relativize(this.file.getAbsoluteFile().toPath()).toString();
            if (abs.length() < rel.length() || rel.startsWith("../../")) {
                builder.append(abs);
            } else {
                builder.append(rel);
            }
        } else if (!hasFormat) {
            builder.append("none");
        }
        return builder.toString();
    }
}

