/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.rpc.handler;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import java.io.IOException;
import java.util.Map;

public class SetHeadersInitializer
implements HttpRequestInitializer {
    private final Map<String, String> headers;
    private final int connect_timeout;
    private final int read_timeout;

    public SetHeadersInitializer(Map<String, String> headers, int connect_timeout, int read_timeout) {
        this.headers = headers;
        this.connect_timeout = connect_timeout;
        this.read_timeout = read_timeout;
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setConnectTimeout(this.connect_timeout);
        request.setReadTimeout(this.read_timeout);
        request.setInterceptor(rq -> {
            HttpHeaders http = rq.getHeaders();
            block18: for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                String value = entry.getValue();
                switch (entry.getKey().toLowerCase()) {
                    case "accept": {
                        http.setAccept(value);
                        continue block18;
                    }
                    case "accept-encoding": {
                        http.setAcceptEncoding(value);
                        continue block18;
                    }
                    case "authorization": {
                        http.setAuthorization(value);
                        continue block18;
                    }
                    case "content-encoding": {
                        http.setContentEncoding(value);
                        continue block18;
                    }
                    case "content-type": {
                        http.setContentType(value);
                        continue block18;
                    }
                    case "user-agent": {
                        http.setUserAgent(value);
                        continue block18;
                    }
                }
                try {
                    http.set(entry.getKey(), value);
                }
                catch (Exception e) {
                    throw new IOException("Unable to set header " + entry.getKey() + ": " + e.getMessage(), e);
                }
            }
        });
    }
}

