/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.rpc;

import com.google.api.client.http.HttpResponseException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.util.Properties;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentParser;
import net.morimekta.providence.PClientHandler;
import net.morimekta.providence.PServiceCall;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.mio.MessageReader;
import net.morimekta.providence.mio.MessageWriter;
import net.morimekta.providence.reflect.parser.ParseException;
import net.morimekta.providence.rpc.RPCOptions;
import net.morimekta.providence.rpc.options.Format;
import net.morimekta.providence.serializer.SerializerException;
import net.morimekta.util.Strings;

public class RPC {
    private final RPCOptions options = new RPCOptions();

    protected RPC() {
    }

    void run(String ... args) {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getResourceAsStream("/build.properties"));
            ArgumentParser cli = this.options.getArgumentParser("pvdrpc", "" + properties.getProperty("build.version"), "Providence RPC Tool");
            cli.parse(args);
            if (this.options.isHelp()) {
                System.out.println("Providence RPC Tool - v" + properties.getProperty("build.version"));
                System.out.println("Usage: pvdrpc [-i spec] [-o spec] [-I dir] [-S] [-f fmt] [-H hdr] -s srv URL");
                System.out.println();
                System.out.println("Example code to run:");
                System.out.println("$ cat call.json | pvdrpc -I thrift/ -s cal.Calculator http://localhost:8080/service");
                System.out.println("$ pvdrpc -i binary,file:my.data -f json_protocol -I thrift/ -s cal.Calculator http://localhost:8080/service");
                System.out.println();
                cli.printUsage(System.out);
                System.out.println();
                System.out.println("Available formats are:");
                for (Format format : Format.values()) {
                    System.out.println(String.format(" - %-20s : %s", format.name(), format.desc));
                }
                return;
            }
            cli.validate();
            MessageReader in = this.options.getInput();
            MessageWriter out = this.options.getOutput();
            PService service = this.options.getDefinition();
            PClientHandler handler = this.options.getHandler();
            PServiceCall call = in.read(service);
            PServiceCall resp = handler.handleCall(call, service);
            out.write(resp);
            return;
        }
        catch (ConnectException e) {
            System.err.format("Unable to connect to %s: %s\n", this.options.endpoint, e.getMessage());
        }
        catch (HttpResponseException e) {
            System.err.println("Received " + e.getStatusCode() + " " + e.getStatusMessage());
            System.err.println(" - from: " + this.options.endpoint);
        }
        catch (ArgumentException e) {
            System.err.println("Usage: pvdrpc [-i spec] [-o spec] [-I dir] [-S] [-f fmt] [-H hdr] -s srv URL");
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Run $ pvdrpc --help # for available options.");
        }
        catch (SerializerException e) {
            System.out.flush();
            System.err.println();
            System.err.println("Serialization error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.out.flush();
            System.err.println();
            if (e.getLine() != null) {
                int lineNo = e.getToken().getLineNo();
                int linePos = e.getToken().getLinePos();
                int len = e.getToken().length();
                System.err.format("Error at line %d, pos %d-%d: %s\n    %s\n    %s%c\n", lineNo, linePos, linePos + len, e.getLocalizedMessage(), e.getLine(), Strings.times("~", linePos), Character.valueOf('^'));
            } else {
                System.err.println("Parser error: " + e.getLocalizedMessage());
            }
        }
        catch (IllegalArgumentException e) {
            System.out.flush();
            System.err.print(e.getMessage());
        }
        catch (IOException | UncheckedIOException e) {
            System.out.flush();
            System.err.println();
            System.err.print("I/O error: ");
            e.printStackTrace();
        }
        this.exit(1);
    }

    protected void exit(int i) {
        System.exit(i);
    }

    public static void main(String[] args) {
        new RPC().run(args);
    }
}

