/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import net.morimekta.providence.reflect.parser.internal.Token;
import net.morimekta.providence.reflect.parser.internal.Tokenizer;

public class ParseException
extends Exception {
    private final String line;
    private final Token token;

    public ParseException(Throwable cause, String message, Object ... params) {
        super(String.format(message, params), cause);
        this.line = null;
        this.token = null;
    }

    public ParseException(String message, Object ... params) {
        super(String.format(message, params));
        this.line = null;
        this.token = null;
    }

    public ParseException(Tokenizer tokenizer, Token token, String message, Object ... params) {
        super(String.format(message, params));
        String line = null;
        try {
            line = tokenizer.getLine(token.getLineNo());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.line = line;
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    public String getLine() {
        return this.line;
    }

    @Override
    public String toString() {
        if (this.line != null && this.token != null) {
            return String.format("ParseException(%s,%d:%d,\"%s\")", this.getLocalizedMessage(), this.token.getLineNo(), this.token.getLinePos(), this.line);
        }
        return String.format("ParseException(%s)", this.getLocalizedMessage());
    }
}

