/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PMessageBuilderFactory;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStruct;

public class CStructDescriptor
extends PStructDescriptor<CStruct, CField>
implements CAnnotatedDescriptor {
    public static final int MAX_COMPACT_FIELDS = 10;
    private final String comment;
    private final CField[] fields;
    private final Map<Integer, CField> fieldIdMap;
    private final Map<String, CField> fieldNameMap;
    private final Map<String, String> annotations;

    public CStructDescriptor(String comment, String packageName, String name, List<CField> fields, Map<String, String> annotations) {
        super(packageName, name, new _Factory(), false, CStructDescriptor.isCompactCompatible(fields, annotations));
        ((_Factory)this.getFactoryInternal()).setType(this);
        this.comment = comment;
        this.fields = fields.toArray(new CField[fields.size()]);
        this.annotations = annotations;
        LinkedHashMap<Integer, CField> fieldIdMap = new LinkedHashMap<Integer, CField>();
        LinkedHashMap<String, CField> fieldNameMap = new LinkedHashMap<String, CField>();
        for (CField field : fields) {
            fieldIdMap.put(field.getKey(), field);
            fieldNameMap.put(field.getName(), field);
        }
        this.fieldIdMap = fieldIdMap;
        this.fieldNameMap = fieldNameMap;
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    public CField[] getFields() {
        return this.fields;
    }

    @Override
    public CField getField(String name) {
        return this.fieldNameMap.get(name);
    }

    @Override
    public CField getField(int key) {
        return this.fieldIdMap.get(key);
    }

    @Override
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    @Override
    public boolean isSimple() {
        for (CField field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isCompactCompatible(List<CField> fields, Map<String, String> annotations) {
        if (annotations == null) {
            return false;
        }
        if (!annotations.containsKey("json.compact") && !annotations.containsKey("compact")) {
            return false;
        }
        if (fields.size() > 10) {
            return false;
        }
        int next = 1;
        boolean hasOptional = false;
        for (CField field : fields) {
            if (field.getKey() != next) {
                return false;
            }
            if (hasOptional && field.getRequirement() == PRequirement.REQUIRED) {
                return false;
            }
            if (field.getRequirement() == PRequirement.OPTIONAL) {
                hasOptional = true;
            }
            ++next;
        }
        return true;
    }

    private static class _Factory
    extends PMessageBuilderFactory<CStruct, CField> {
        private CStructDescriptor mType;

        private _Factory() {
        }

        public void setType(CStructDescriptor type) {
            this.mType = type;
        }

        @Override
        public PMessageBuilder<CStruct, CField> builder() {
            return new CStruct.Builder(this.mType);
        }
    }
}

