/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.chr;

import net.morimekta.console.chr.Char;
import net.morimekta.util.Strings;

public class Control
implements Char {
    public static final Control UP = new Control("\u001b[A");
    public static final Control DOWN = new Control("\u001b[B");
    public static final Control RIGHT = new Control("\u001b[C");
    public static final Control LEFT = new Control("\u001b[D");
    public static final Control CTRL_UP = new Control("\u001b[1;5A");
    public static final Control CTRL_DOWN = new Control("\u001b[1;5B");
    public static final Control CTRL_RIGHT = new Control("\u001b[1;5C");
    public static final Control CTRL_LEFT = new Control("\u001b[1;5D");
    public static final Control CURSOR_ERASE = new Control("\u001b[K");
    public static final Control CURSOR_SAVE = new Control("\u001b[s");
    public static final Control CURSOR_RESTORE = new Control("\u001b[u");
    public static final Control DPAD_MID = new Control("\u001b[E");
    public static final Control INSERT = new Control("\u001b[2~");
    public static final Control DELETE = new Control("\u001b[3~");
    public static final Control HOME = new Control("\u001b[1~");
    public static final Control END = new Control("\u001b[4~");
    public static final Control PAGE_UP = new Control("\u001b[5~");
    public static final Control PAGE_DOWN = new Control("\u001b[6~");
    public static final Control F1 = new Control("\u001bOP");
    public static final Control F2 = new Control("\u001bOQ");
    public static final Control F3 = new Control("\u001bOR");
    public static final Control F4 = new Control("\u001bOS");
    public static final Control F5 = new Control("\u001b[15~");
    public static final Control F6 = new Control("\u001b[17~");
    public static final Control F7 = new Control("\u001b[18~");
    public static final Control F8 = new Control("\u001b[19~");
    public static final Control F9 = new Control("\u001b[20~");
    private final String str;

    public Control(CharSequence str) {
        this.str = str.equals("\u001bOH") ? Control.HOME.str : (str.equals("\u001bOF") ? Control.END.str : str.toString());
    }

    public static Control cursorSetPos(int line) {
        return Control.cursorSetPos(line, 0);
    }

    public static Control cursorSetPos(int line, int col) {
        return new Control(String.format("\u001b[%d;%dH", line, col));
    }

    public static Control cursorUp(int num) {
        return new Control(String.format("\u001b[%dA", num));
    }

    public static Control cursorDown(int num) {
        return new Control(String.format("\u001b[%dB", num));
    }

    public static Control cursorRight(int num) {
        return new Control(String.format("\u001b[%dC", num));
    }

    public static Control cursorLeft(int num) {
        return new Control(String.format("\u001b[%dD", num));
    }

    @Override
    public int asInteger() {
        return -1;
    }

    @Override
    public String asString() {
        if (this.str.equals(Control.UP.str)) {
            return "<up>";
        }
        if (this.str.equals(Control.DOWN.str)) {
            return "<down>";
        }
        if (this.str.equals(Control.RIGHT.str)) {
            return "<right>";
        }
        if (this.str.equals(Control.LEFT.str)) {
            return "<left>";
        }
        if (this.str.equals(Control.CTRL_UP.str)) {
            return "<C-up>";
        }
        if (this.str.equals(Control.CTRL_DOWN.str)) {
            return "<C-down>";
        }
        if (this.str.equals(Control.CTRL_RIGHT.str)) {
            return "<C-right>";
        }
        if (this.str.equals(Control.CTRL_LEFT.str)) {
            return "<C-left>";
        }
        if (this.str.equals(Control.CURSOR_ERASE.str)) {
            return "<cursor-erase>";
        }
        if (this.str.equals(Control.CURSOR_SAVE.str)) {
            return "<cursor-save>";
        }
        if (this.str.equals(Control.CURSOR_RESTORE.str)) {
            return "<cursor-restore>";
        }
        if (this.str.equals(Control.DPAD_MID.str)) {
            return "<dpa-mid>";
        }
        if (this.str.equals(Control.INSERT.str)) {
            return "<insert>";
        }
        if (this.str.equals(Control.DELETE.str)) {
            return "<delete>";
        }
        if (this.str.equals(Control.HOME.str)) {
            return "<home>";
        }
        if (this.str.equals(Control.END.str)) {
            return "<end>";
        }
        if (this.str.equals(Control.PAGE_UP.str)) {
            return "<pg-up>";
        }
        if (this.str.equals(Control.PAGE_DOWN.str)) {
            return "<pg-down>";
        }
        if (this.str.equals(Control.F1.str)) {
            return "<F1>";
        }
        if (this.str.equals(Control.F2.str)) {
            return "<F2>";
        }
        if (this.str.equals(Control.F3.str)) {
            return "<F3>";
        }
        if (this.str.equals(Control.F4.str)) {
            return "<F4>";
        }
        if (this.str.equals(Control.F5.str)) {
            return "<F5>";
        }
        if (this.str.equals(Control.F6.str)) {
            return "<F6>";
        }
        if (this.str.equals(Control.F7.str)) {
            return "<F7>";
        }
        if (this.str.equals(Control.F8.str)) {
            return "<F8>";
        }
        if (this.str.equals(Control.F9.str)) {
            return "<F9>";
        }
        if (this.str.length() == 2 && this.str.charAt(1) >= 'a' && this.str.charAt(1) <= 'z') {
            return "<M-" + this.str.charAt(1) + '>';
        }
        return Strings.escape(this.str);
    }

    @Override
    public int printableWidth() {
        return 0;
    }

    @Override
    public int length() {
        return this.str.length();
    }

    public String toString() {
        return this.str;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Control)) {
            return false;
        }
        Control other = (Control)o;
        return this.str.equals(other.str);
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    @Override
    public int compareTo(Char o) {
        if (o instanceof Control) {
            return this.str.compareTo(((Control)o).str);
        }
        return Integer.compare(this.asInteger(), o.asInteger());
    }
}

