/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.chr;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import net.morimekta.console.chr.Control;
import net.morimekta.util.Strings;

public class Color
extends Control {
    public static final Color CLEAR = new Color(0);
    public static final Color DEFAULT = new Color(39);
    public static final Color BLACK = new Color(30);
    public static final Color RED = new Color(31);
    public static final Color GREEN = new Color(32);
    public static final Color YELLOW = new Color(33);
    public static final Color BLUE = new Color(34);
    public static final Color MAGENTA = new Color(35);
    public static final Color CYAN = new Color(36);
    public static final Color WHITE = new Color(37);
    public static final Color BG_DEFAULT = new Color(49);
    public static final Color BG_BLACK = new Color(40);
    public static final Color BG_RED = new Color(41);
    public static final Color BG_GREEN = new Color(42);
    public static final Color BG_YELLOW = new Color(43);
    public static final Color BG_BLUE = new Color(44);
    public static final Color BG_MAGENTA = new Color(45);
    public static final Color BG_CYAN = new Color(46);
    public static final Color BG_WHITE = new Color(47);
    public static final Color BOLD = new Color(1);
    public static final Color DIM = new Color(2);
    public static final Color UNDERLINE = new Color(4);
    public static final Color STROKE = new Color(9);
    public static final Color INVERT = new Color(7);
    public static final Color HIDDEN = new Color(8);
    public static final Color UNSET_BOLD = new Color(21);
    public static final Color UNSET_DIM = new Color(22);
    public static final Color UNSET_UNDERLINE = new Color(24);
    public static final Color UNSET_STROKE = new Color(29);
    public static final Color UNSET_INVERT = new Color(27);
    public static final Color UNSET_HIDDEN = new Color(28);
    private final int[] mods;

    public Color(int ... values) {
        this(Color.mkModSet(values));
    }

    public Color(Color ... colors) {
        this(Color.mkModSet(colors));
    }

    public Color(CharSequence ctrl) {
        this(Color.parseModSet(ctrl));
    }

    private Color(TreeSet<Integer> mods) {
        super(Color.mkString(mods));
        this.mods = new int[mods.size()];
        int i = 0;
        Iterator<Integer> iterator = mods.iterator();
        while (iterator.hasNext()) {
            int v;
            this.mods[i] = v = iterator.next().intValue();
            ++i;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Color)) {
            return false;
        }
        Color other = (Color)o;
        return Arrays.equals(this.mods, other.mods);
    }

    private static String mkString(TreeSet<Integer> values) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u001b[");
        boolean first = true;
        for (int i : values) {
            if (first) {
                first = false;
            } else {
                builder.append(';');
            }
            builder.append(String.format("%02d", i));
        }
        builder.append("m");
        return builder.toString();
    }

    private static TreeSet<Integer> mkModSet(Color ... colors) {
        TreeSet<Integer> mods = new TreeSet<Integer>();
        int fg = 0;
        int bg = 0;
        block0: for (Color c : colors) {
            for (int i : c.mods) {
                if (i == 0) {
                    fg = 0;
                    bg = 0;
                    mods.clear();
                    mods.add(0);
                    break block0;
                }
                if (i < 10) {
                    mods.add(i);
                    mods.remove(i + 20);
                    continue;
                }
                if (i < 30) {
                    mods.add(i);
                    mods.remove(i - 20);
                    continue;
                }
                if (i < 40) {
                    fg = i;
                    continue;
                }
                if (i >= 50) continue;
                bg = i;
            }
        }
        if (fg != 0) {
            mods.add(fg);
        }
        if (bg != 0) {
            mods.add(bg);
        }
        return mods;
    }

    private static TreeSet<Integer> mkModSet(int ... values) {
        TreeSet<Integer> mods = new TreeSet<Integer>();
        int fg = 0;
        int bg = 0;
        for (int i : values) {
            if (i == 0) {
                fg = 0;
                bg = 0;
                mods.clear();
                mods.add(0);
                break;
            }
            if (i < 10) {
                mods.add(i);
                mods.remove(i + 20);
                continue;
            }
            if (i < 30) {
                mods.add(i);
                mods.remove(i - 20);
                continue;
            }
            if (i < 40) {
                fg = i;
                continue;
            }
            if (i >= 50) continue;
            bg = i;
        }
        if (fg != 0) {
            mods.add(fg);
        }
        if (bg != 0) {
            mods.add(bg);
        }
        return mods;
    }

    private static TreeSet<Integer> parseModSet(CharSequence ctrl) {
        int v = 0;
        int n = 0;
        TreeSet<Integer> mods = new TreeSet<Integer>();
        for (int i = 2; i < ctrl.length(); ++i) {
            char c = ctrl.charAt(i);
            if ('0' <= c && c <= '9') {
                v *= 10;
                v += c - 48;
                ++n;
                continue;
            }
            if (n > 0) {
                mods.add(v);
                v = 0;
                n = 0;
                continue;
            }
            throw new IllegalArgumentException("Invalid color control sequence: \"" + Strings.escape(ctrl) + "\"");
        }
        return mods;
    }
}

