/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.chr;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.morimekta.console.chr.Char;
import net.morimekta.console.chr.Color;
import net.morimekta.console.chr.Control;
import net.morimekta.console.chr.Unicode;

public class CharStream {
    public static Iterator<Char> iterator(CharSequence str) {
        return Spliterators.iterator(new CharSpliterator(str));
    }

    public static Stream<Char> stream(CharSequence str) {
        return StreamSupport.stream(new CharSpliterator(str), false);
    }

    private CharStream() {
    }

    private static class CharSpliterator
    implements Spliterator<Char> {
        private final CharSequence cstr;
        private volatile int pos;

        private CharSpliterator(CharSequence cstr) {
            this.cstr = cstr;
            this.pos = 0;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Char> consumer) {
            if (this.pos >= this.cstr.length()) {
                return false;
            }
            int c = this.cstr.charAt(this.pos);
            if (c == 27) {
                int r = this.cstr.length() - this.pos;
                if (r == 1) {
                    consumer.accept(new Unicode((char)c));
                    ++this.pos;
                    return true;
                }
                char c2 = this.cstr.charAt(this.pos + 1);
                if (r > 2 && c2 == '[') {
                    char c3 = this.cstr.charAt(this.pos + 2);
                    if ('A' <= c3 && c3 <= 'Z') {
                        consumer.accept(new Control(this.cstr.subSequence(this.pos, this.pos + 3)));
                        this.pos += 3;
                        return true;
                    }
                    int n = 2;
                    while ('0' <= c3 && c3 <= '9' || c3 == ';') {
                        if (this.pos + ++n == this.cstr.length()) {
                            consumer.accept(new Unicode((char)c));
                            ++this.pos;
                            return true;
                        }
                        c3 = this.cstr.charAt(this.pos + n);
                    }
                    if (c3 == '~' || 'a' <= c3 && c3 <= 'z' || 'A' <= c3 && c3 <= 'Z') {
                        if (c3 == 'm') {
                            consumer.accept(new Color(this.cstr.subSequence(this.pos, this.pos + n + 1)));
                        } else {
                            consumer.accept(new Control(this.cstr.subSequence(this.pos, this.pos + n + 1)));
                        }
                        this.pos += n + 1;
                        return true;
                    }
                } else if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z') {
                    char c3;
                    if (r > 2 && c2 == 'O' && 'A' <= (c3 = this.cstr.charAt(this.pos + 2)) && c3 <= 'Z') {
                        consumer.accept(new Control(this.cstr.subSequence(this.pos, this.pos + 3)));
                        this.pos += 3;
                        return true;
                    }
                    consumer.accept(new Control(this.cstr.subSequence(this.pos, this.pos + 2)));
                    this.pos += 3;
                    return true;
                }
                consumer.accept(new Unicode((char)c));
                ++this.pos;
                return true;
            }
            int cp = c;
            if (Character.isHighSurrogate((char)c)) {
                ++this.pos;
                cp = Character.toCodePoint((char)c, this.cstr.charAt(this.pos));
            }
            consumer.accept(new Unicode(cp));
            ++this.pos;
            return true;
        }

        @Override
        public Spliterator<Char> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

