/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.console.args;

import java.util.function.Consumer;
import net.morimekta.console.args.ArgumentException;
import net.morimekta.console.args.ArgumentList;
import net.morimekta.console.args.BaseOption;

public class Option
extends BaseOption {
    private final Consumer<String> setter;
    private boolean applied = false;

    public Option(String name, String shortNames, String metaVar, String usage, Consumer<String> setter) {
        this(name, shortNames, metaVar, usage, setter, null);
    }

    public Option(String name, String shortNames, String metaVar, String usage, Consumer<String> setter, String defaultValue) {
        this(name, shortNames, metaVar, usage, setter, defaultValue, false, false, false);
    }

    public Option(String name, String shortNames, String metaVar, String usage, Consumer<String> setter, String defaultValue, boolean repeated, boolean required, boolean hidden) {
        super(name, shortNames, metaVar, usage, defaultValue, repeated, required, hidden);
        this.setter = setter;
    }

    @Override
    public int applyShort(String opts, ArgumentList args) {
        if (this.applied && !this.isRepeated()) {
            throw new ArgumentException("Option " + this.nameOrShort() + " already applied", new Object[0]);
        }
        this.applied = true;
        if (opts.length() == 1) {
            if (args.remaining() <= 1) {
                throw new ArgumentException("Missing value after -" + opts, new Object[0]);
            }
            this.setter.accept(args.get(1));
            return 2;
        }
        String value = opts.substring(1);
        this.setter.accept(value);
        return 1;
    }

    @Override
    public void validate() throws ArgumentException {
        if (this.isRequired() && !this.applied) {
            throw new ArgumentException("Option " + this.nameOrShort() + " is required", new Object[0]);
        }
    }

    @Override
    public int apply(ArgumentList args) throws ArgumentException {
        if (this.applied && !this.isRepeated()) {
            throw new ArgumentException("Option " + this.nameOrShort() + " already applied", new Object[0]);
        }
        if (this.getName() == null) {
            throw new IllegalStateException("No long option for -[" + this.getShortNames() + "]");
        }
        this.applied = true;
        String current = args.get(0);
        if (current.startsWith(this.getName() + "=")) {
            String value = current.substring(this.getName().length() + 1);
            this.setter.accept(value);
            return 1;
        }
        if (current.equals(this.getName())) {
            if (args.remaining() < 2) {
                throw new ArgumentException("Missing value after " + this.getName(), new Object[0]);
            }
            this.setter.accept(args.get(1));
            return 2;
        }
        throw new IllegalArgumentException("Argument not matching option " + this.nameOrShort() + ": " + current);
    }
}

