/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.parser.ThriftTokenType;
import net.morimekta.util.Strings;
import net.morimekta.util.io.Utf8StreamReader;
import net.morimekta.util.lexer.TokenizerBase;

public class ThriftTokenizer
extends TokenizerBase<ThriftTokenType, ThriftToken> {
    public static final String kNamespace = "namespace";
    public static final String kInclude = "include";
    public static final String kTypedef = "typedef";
    public static final String kEnum = "enum";
    public static final String kStruct = "struct";
    public static final String kUnion = "union";
    public static final String kException = "exception";
    public static final String kInterface = "interface";
    public static final String kConst = "const";
    public static final String kService = "service";
    public static final String kExtends = "extends";
    public static final String kVoid = "void";
    public static final String kOneway = "oneway";
    public static final String kThrows = "throws";
    public static final String kRequired = "required";
    public static final String kOptional = "optional";
    public static final String kImplements = "implements";
    public static final String kOf = "of";
    public static final String kNull = "null";

    public ThriftTokenizer(InputStream in) {
        this((Reader)new Utf8StreamReader(in));
    }

    public ThriftTokenizer(Reader reader) {
        super(reader, 2048, true);
    }

    protected ThriftToken genericToken(char[] buffer, int offset, int len, @Nonnull ThriftTokenType type, int lineNo, int linePos) {
        return new ThriftToken(buffer, offset, len, type, lineNo, linePos);
    }

    @Nullable
    public ThriftToken parseNextToken() throws IOException {
        ThriftToken token = (ThriftToken)super.parseNextToken();
        while (token != null && token.type() == ThriftTokenType.COMMENT) {
            token = (ThriftToken)super.parseNextToken();
        }
        return token;
    }

    protected ThriftToken identifierToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new ThriftToken(buffer, offset, len, ThriftTokenType.IDENTIFIER, lineNo, linePos);
    }

    protected ThriftToken stringToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new ThriftToken(buffer, offset, len, ThriftTokenType.STRING, lineNo, linePos);
    }

    protected ThriftToken numberToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new ThriftToken(buffer, offset, len, ThriftTokenType.NUMBER, lineNo, linePos);
    }

    protected ThriftToken symbolToken(char[] buffer, int offset, int len, int lineNo, int linePos) {
        return new ThriftToken(buffer, offset, len, ThriftTokenType.SYMBOL, lineNo, linePos);
    }

    protected boolean startString() {
        return this.lastChar == 34 || this.lastChar == 39;
    }

    @Nonnull
    protected ThriftToken nextSymbol() throws IOException {
        if (this.lastChar == 47) {
            int startOffset = this.bufferOffset;
            int startLinePos = this.linePos;
            if (!this.readNextChar()) {
                throw this.eofFailure("Expected java-style comment, got end of file", new Object[0]);
            }
            if (this.lastChar == 47) {
                this.lastChar = 0;
                ThriftToken token = (ThriftToken)this.readUntil("\n", (Object)ThriftTokenType.COMMENT, true);
                if (token == null) {
                    return this.genericToken("".toCharArray(), 0, 0, ThriftTokenType.COMMENT, this.lineNo, startLinePos + 2);
                }
                return token;
            }
            if (this.lastChar == 42) {
                this.lastChar = 0;
                ThriftToken token = (ThriftToken)this.readUntil("*/", (Object)ThriftTokenType.DOCUMENTATION, false);
                if (token == null) {
                    return this.genericToken("".toCharArray(), 0, 0, ThriftTokenType.COMMENT, this.lineNo, startLinePos + 2);
                }
                return token;
            }
            ThriftToken token = this.symbolToken(this.buffer, startOffset, 2, this.lineNo, startLinePos);
            throw this.failure(token, "Expected java-style comment, got '%s' after '/'", new Object[]{Strings.escape((char)((char)this.lastChar))});
        }
        return (ThriftToken)super.nextSymbol();
    }

    protected boolean allowIdentifier(int last) {
        return last == 45 || super.allowIdentifier(last);
    }
}

