/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.PUnion;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PContainer;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PUnionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CStruct;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.collect.UnmodifiableSortedMap;
import net.morimekta.util.collect.UnmodifiableSortedSet;

public class CUnion
implements PUnion<CUnion> {
    private final CUnionDescriptor descriptor;
    private final CField<CUnion> unionField;
    private final Object unionValue;

    private CUnion(Builder builder) {
        this.unionField = builder.unionField;
        this.descriptor = builder.descriptor;
        this.unionValue = builder.currentValue instanceof PMessageBuilder ? ((PMessageBuilder)builder.currentValue).build() : (builder.currentValue instanceof List ? UnmodifiableList.copyOf((Collection)((List)builder.currentValue)) : (builder.currentValue instanceof Map ? (PContainer.typeForName((String)this.unionField.getAnnotationValue(PAnnotation.CONTAINER)) == PContainer.Type.SORTED ? UnmodifiableSortedMap.copyOf((Map)((Map)builder.currentValue)) : UnmodifiableMap.copyOf((Map)((Map)builder.currentValue))) : (builder.currentValue instanceof Set ? (PContainer.typeForName((String)this.unionField.getAnnotationValue(PAnnotation.CONTAINER)) == PContainer.Type.SORTED ? UnmodifiableSortedSet.copyOf((Collection)((Set)builder.currentValue)) : UnmodifiableSet.copyOf((Collection)((Set)builder.currentValue))) : builder.currentValue)));
    }

    public boolean has(int key) {
        return this.unionField != null && this.unionField.getId() == key && this.unionValue != null;
    }

    public <T> T get(int key) {
        return (T)(this.has(key) ? this.unionValue : null);
    }

    @Nonnull
    public PMessageBuilder<CUnion> mutate() {
        return new Builder(this);
    }

    @Nonnull
    public String asString() {
        return CStruct.asString(this);
    }

    public String toString() {
        return this.descriptor.getQualifiedName() + this.asString();
    }

    @Nonnull
    public CUnionDescriptor descriptor() {
        return this.descriptor;
    }

    public boolean unionFieldIsSet() {
        return this.unionField != null;
    }

    @Nonnull
    public CField<CUnion> unionField() {
        if (this.unionField == null) {
            throw new IllegalStateException("No union field set in " + this.descriptor.getQualifiedName());
        }
        return this.unionField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CUnion)) {
            return false;
        }
        CUnion other = (CUnion)o;
        return Objects.equals(this.descriptor, other.descriptor) && Objects.equals(this.unionField, other.unionField) && Objects.equals(this.unionValue, other.unionValue);
    }

    public int hashCode() {
        return Objects.hash(this.descriptor().getQualifiedName(), this.unionField, this.unionValue);
    }

    public int compareTo(@Nonnull CUnion other) {
        return CStruct.compareMessages(this, other);
    }

    public static class Builder
    extends PMessageBuilder<CUnion> {
        private final CUnionDescriptor descriptor;
        private CField<CUnion> originalField;
        private boolean updated;
        private CField<CUnion> unionField;
        private Object currentValue;

        public Builder(CUnionDescriptor descriptor) {
            this.descriptor = descriptor;
            this.originalField = null;
            this.updated = false;
        }

        public Builder(CUnion union) {
            this.descriptor = union.descriptor;
            if (union.unionField != null) {
                this.set(union.unionField, union.unionValue);
            }
            this.originalField = union.unionField;
            this.updated = false;
        }

        @Nonnull
        public PMessageBuilder<?> mutator(int key) {
            PField field = this.descriptor.findFieldById(key);
            if (field == null) {
                throw new IllegalArgumentException("No such field ID " + key);
            }
            if (field.getType() != PType.MESSAGE) {
                throw new IllegalArgumentException("Not a message field ID " + key + ": " + field.getName());
            }
            if (this.unionField != field) {
                this.unionField = field;
                this.currentValue = null;
            }
            this.updated = true;
            if (this.currentValue == null) {
                this.currentValue = ((PMessageDescriptor)field.getDescriptor()).builder();
            } else if (this.currentValue instanceof PMessage) {
                this.currentValue = ((PMessage)this.currentValue).mutate();
            } else if (!(this.currentValue instanceof PMessageBuilder)) {
                throw new IllegalArgumentException("Invalid currentValue in map on message type: " + this.currentValue.getClass().getSimpleName());
            }
            return (PMessageBuilder)this.currentValue;
        }

        @Nonnull
        public Builder merge(@Nonnull CUnion from) {
            if (this.unionField == null || this.unionField != from.unionField) {
                if (from.unionField != null) {
                    this.set(from.unionField.getId(), from.unionValue);
                }
            } else {
                this.updated = true;
                int key = this.unionField.getId();
                switch (this.unionField.getType()) {
                    case MESSAGE: {
                        PMessageBuilder src = this.currentValue instanceof PMessageBuilder ? (PMessageBuilder)this.currentValue : ((PMessage)this.currentValue).mutate();
                        PMessage toMerge = (PMessage)from.get(key);
                        this.currentValue = src.merge(toMerge);
                        break;
                    }
                    case SET: {
                        ((Set)this.currentValue).addAll((Collection)from.get(key));
                        break;
                    }
                    case MAP: {
                        ((Map)this.currentValue).putAll((Map)from.get(key));
                        break;
                    }
                    default: {
                        this.set(key, from.get(key));
                    }
                }
            }
            return this;
        }

        public boolean has(int key) {
            PField field = this.descriptor.findFieldById(key);
            return field != null && this.unionField == field;
        }

        public <T> T get(int key) {
            PField field = this.descriptor.findFieldById(key);
            if (this.unionField == field) {
                return (T)this.currentValue;
            }
            return null;
        }

        @Nonnull
        public PUnionDescriptor<CUnion> descriptor() {
            return this.descriptor;
        }

        @Nonnull
        public CUnion build() {
            return new CUnion(this);
        }

        public boolean valid() {
            return this.unionField != null && this.currentValue != null;
        }

        public Builder validate() {
            if (!this.valid()) {
                throw new IllegalStateException("No union field set in " + this.descriptor().getQualifiedName());
            }
            return this;
        }

        @Nonnull
        public Builder set(int key, Object value) {
            PField field = this.descriptor.findFieldById(key);
            if (field == null) {
                return this;
            }
            if (value == null) {
                return this.clear(key);
            }
            this.updated = true;
            this.unionField = field;
            switch (field.getType()) {
                case SET: {
                    this.currentValue = new LinkedHashSet((Collection)value);
                    break;
                }
                case LIST: {
                    this.currentValue = new ArrayList((Collection)value);
                    break;
                }
                case MAP: {
                    this.currentValue = new LinkedHashMap((Map)value);
                    break;
                }
                default: {
                    this.currentValue = value;
                }
            }
            return this;
        }

        public boolean isSet(int key) {
            return this.unionField != null && this.unionField.getId() == key;
        }

        public boolean isModified(int key) {
            if (this.updated) {
                if (this.unionField != null && this.unionField.getId() == key) {
                    return true;
                }
                return this.originalField != null && this.originalField.getId() == key;
            }
            return false;
        }

        @Nonnull
        public Builder addTo(int key, Object value) {
            PField field = this.descriptor.findFieldById(key);
            if (field == null) {
                return this;
            }
            if (field.getType() != PType.LIST && field.getType() != PType.SET) {
                throw new IllegalArgumentException("Unable to accept addTo on non-list field " + field.getName());
            }
            if (value == null) {
                throw new IllegalArgumentException("Adding null item to collection " + field.getName());
            }
            this.updated = true;
            if (this.unionField != field || this.currentValue == null) {
                this.unionField = field;
                switch (field.getType()) {
                    case LIST: {
                        this.currentValue = new ArrayList();
                        break;
                    }
                    case SET: {
                        this.currentValue = new LinkedHashSet();
                        break;
                    }
                }
            }
            ((Collection)this.currentValue).add(value);
            return this;
        }

        @Nonnull
        public Builder clear(int key) {
            if (this.isSet(key)) {
                this.updated = true;
                if (this.originalField == null) {
                    this.originalField = this.unionField;
                }
                this.unionField = null;
                this.currentValue = null;
            }
            return this;
        }
    }
}

