/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.util.Strings;

public class ReflectionUtils {
    public static boolean isDeclaredType(PDeclaredDescriptor<?> descriptor) {
        return !descriptor.isAutoType();
    }

    @Deprecated
    public static boolean isThriftFile(@Nonnull File file) {
        return ReflectionUtils.isThriftBasedFileSyntax(file.toPath());
    }

    @Deprecated
    public static boolean isThriftFile(@Nonnull String filePath) {
        return ReflectionUtils.isThriftBasedFileSyntax(Paths.get(filePath, new String[0]));
    }

    @Deprecated
    public static boolean isProvidenceFile(@Nonnull File file) {
        return ReflectionUtils.isProvidenceFile(file.toPath());
    }

    @Deprecated
    public static boolean isProvidenceFile(@Nonnull String filePath) {
        return ReflectionUtils.isProvidenceFile(Paths.get(filePath, new String[0]));
    }

    @Nonnull
    @Deprecated
    public static String programNameFromPath(@Nonnull String filePath) {
        return ReflectionUtils.programNameFromPath(Paths.get(filePath, new String[0]));
    }

    @Nonnull
    protected static String getFileName(@Nonnull Path path) {
        if (path.getFileName() == null) {
            return "";
        }
        return path.getFileName().toString().replaceAll("([^.])\\.[^.]+$", "$1");
    }

    @Nonnull
    public static String getFileSuffix(@Nonnull Path path) {
        if (path.getFileName() == null) {
            return "";
        }
        return path.getFileName().toString().substring(ReflectionUtils.getFileName(path).length());
    }

    public static boolean isThriftFileSuffix(@Nonnull String suffix) {
        return suffix.equalsIgnoreCase(".thrift") || suffix.equalsIgnoreCase(".thr");
    }

    public static boolean isProvidenceFileSuffix(@Nonnull String suffix) {
        return suffix.equalsIgnoreCase(".providence") || suffix.equalsIgnoreCase(".pvd");
    }

    public static boolean isProvidenceFile(@Nonnull Path file) {
        return ReflectionUtils.isProvidenceFileSuffix(ReflectionUtils.getFileSuffix(file));
    }

    public static boolean isApacheThriftFile(@Nonnull Path file) {
        return ReflectionUtils.isThriftFileSuffix(ReflectionUtils.getFileSuffix(file));
    }

    public static boolean isThriftBasedFileSyntax(@Nonnull Path file) {
        String suffix = ReflectionUtils.getFileSuffix(file);
        return ReflectionUtils.isThriftFileSuffix(suffix) || ReflectionUtils.isProvidenceFileSuffix(suffix);
    }

    @Nonnull
    public static String programNameFromPath(@Nonnull Path filePath) {
        if (ReflectionUtils.isThriftBasedFileSyntax(filePath)) {
            return ReflectionUtils.getFileName(filePath).replaceAll("[^a-zA-Z0-9_]", "_");
        }
        return "";
    }

    @Nonnull
    public static String longestCommonPrefixPath(Collection<String> paths) {
        if (paths.size() == 0) {
            throw new IllegalArgumentException("Empty paths");
        }
        String prefix = paths.iterator().next();
        for (String s : paths) {
            int len = Strings.commonPrefix((String)s, (String)prefix);
            if (len >= prefix.length()) continue;
            prefix = prefix.substring(0, len);
        }
        if (prefix.contains("/")) {
            return prefix.replaceAll("/[^/]*$", "/");
        }
        return "";
    }

    @Nonnull
    public static List<String> stripCommonPrefix(List<String> paths) {
        String prefix = ReflectionUtils.longestCommonPrefixPath(paths);
        if (prefix.length() > 0) {
            return paths.stream().map(s -> s.substring(prefix.length())).collect(Collectors.toList());
        }
        return paths;
    }

    private ReflectionUtils() {
    }
}

