/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.model;

import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.util.ReflectionUtils;

public class IncludeDeclaration {
    private final ThriftToken includeToken;
    private final ThriftToken filePath;
    private final ThriftToken programNameAlias;
    private final String programName;

    public IncludeDeclaration(@Nonnull ThriftToken includeToken, @Nonnull ThriftToken filePath, @Nullable ThriftToken programNameAlias) {
        this.includeToken = includeToken;
        this.filePath = filePath;
        this.programNameAlias = programNameAlias;
        this.programName = programNameAlias == null ? ReflectionUtils.programNameFromPath(Paths.get(this.getFilePath(), new String[0])) : programNameAlias.toString();
    }

    @Nonnull
    public ThriftToken getIncludeToken() {
        return this.includeToken;
    }

    @Nonnull
    public String getFilePath() {
        return this.filePath.decodeString(false);
    }

    @Nonnull
    public ThriftToken getFilePathToken() {
        return this.filePath;
    }

    @Nonnull
    public String getProgramName() {
        return this.programName;
    }

    @Nullable
    public ThriftToken getProgramNameToken() {
        return this.programNameAlias;
    }

    public String toString() {
        return "ThriftInclude{" + (Object)((Object)this.programNameAlias) + "=\"" + this.getFilePath() + "\"}";
    }
}

