/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PInterfaceDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PMessageDescriptorProvider;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CInterface;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.util.collect.UnmodifiableList;

public class CInterfaceDescriptor
extends PInterfaceDescriptor<CInterface>
implements CMessageDescriptor {
    private final Map<String, String> annotations;
    private final String comment;
    private final ArrayList<PMessageDescriptor<?>> possibleTypes;

    public CInterfaceDescriptor(String comment, String packageName, String name, List<CField<CInterface>> fields, Map<String, String> annotations) {
        super(packageName, name, (PField[])fields.toArray(CField.EMPTY_ARRAY), new PMessageDescriptorProvider[0]);
        for (CField<CInterface> field : fields) {
            field.setMessageType((PMessageDescriptor<CInterface>)this);
        }
        this.comment = comment;
        this.annotations = annotations;
        this.possibleTypes = new ArrayList();
    }

    public void addPossibleType(PMessageDescriptor<?> descriptor) {
        this.possibleTypes.add(descriptor);
    }

    public List<PMessageDescriptor<?>> getPossibleTypes() {
        return UnmodifiableList.copyOf(this.possibleTypes);
    }

    @Override
    public final String getDocumentation() {
        return this.comment;
    }

    @Override
    @Nullable
    public CInterfaceDescriptor getImplementing() {
        return null;
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }
}

