/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.reflect.model.AnnotationDeclaration;
import net.morimekta.providence.reflect.model.ConstDeclaration;
import net.morimekta.providence.reflect.model.Declaration;
import net.morimekta.providence.reflect.model.EnumDeclaration;
import net.morimekta.providence.reflect.model.EnumValueDeclaration;
import net.morimekta.providence.reflect.model.FieldDeclaration;
import net.morimekta.providence.reflect.model.IncludeDeclaration;
import net.morimekta.providence.reflect.model.MessageDeclaration;
import net.morimekta.providence.reflect.model.MethodDeclaration;
import net.morimekta.providence.reflect.model.NamespaceDeclaration;
import net.morimekta.providence.reflect.model.ProgramDeclaration;
import net.morimekta.providence.reflect.model.ServiceDeclaration;
import net.morimekta.providence.reflect.model.TypedefDeclaration;
import net.morimekta.providence.reflect.parser.ThriftConstants;
import net.morimekta.providence.reflect.parser.ThriftException;
import net.morimekta.providence.reflect.parser.ThriftLexer;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.parser.ThriftTokenType;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.util.Strings;
import net.morimekta.util.lexer.LexerException;

public class ThriftParser {
    private final boolean requireFieldId;
    private final boolean requireEnumValue;
    private final boolean allowLanguageReservedNames;
    private final boolean allowProvidenceOnlyFeatures;
    private static final Pattern VALID_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern VALID_NAMESPACE = Pattern.compile("([_a-zA-Z][_a-zA-Z0-9]*[.])*[_a-zA-Z][_a-zA-Z0-9]*");

    ThriftParser() {
        this(false, false, true, false);
    }

    public ThriftParser(boolean requireFieldId, boolean requireEnumValue, boolean allowLanguageReservedNames, boolean allowProvidenceOnlyFeatures) {
        this.requireFieldId = requireFieldId;
        this.requireEnumValue = requireEnumValue;
        this.allowLanguageReservedNames = allowLanguageReservedNames;
        this.allowProvidenceOnlyFeatures = allowProvidenceOnlyFeatures;
    }

    public ProgramDeclaration parse(InputStream in, Path file) throws IOException {
        try {
            return this.parseInternal(in, file);
        }
        catch (ThriftException e) {
            if (e.getFile() == null) {
                e.setFile(file.getFileName().toString());
            }
            throw e;
        }
        catch (LexerException e) {
            throw new ThriftException(e, e.getMessage(), new Object[0]).setFile(file.getFileName().toString());
        }
    }

    private ProgramDeclaration parseInternal(@Nonnull InputStream in, @Nonnull Path file) throws IOException {
        ThriftToken token;
        String documentation = null;
        ArrayList<IncludeDeclaration> includes = new ArrayList<IncludeDeclaration>();
        ArrayList<NamespaceDeclaration> namespaces = new ArrayList<NamespaceDeclaration>();
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        String programName = ReflectionUtils.programNameFromPath(file.getFileName());
        HashSet<String> includedPrograms = new HashSet<String>();
        ThriftLexer lexer = new ThriftLexer(in);
        boolean has_header = false;
        boolean hasDeclaration = false;
        String doc_string = null;
        block22: while ((token = (ThriftToken)lexer.next()) != null) {
            if (token.type() == ThriftTokenType.DOCUMENTATION) {
                if (doc_string != null && !has_header) {
                    documentation = doc_string;
                }
                doc_string = token.parseDocumentation();
                continue;
            }
            String keyword = token.toString();
            if (!(ThriftConstants.kThriftKeywords.contains(keyword) || this.allowProvidenceOnlyFeatures && ThriftConstants.kProvidenceKeywords.contains(keyword))) {
                throw lexer.failure(token, "Unexpected token '%s'", new Object[]{token});
            }
            switch (keyword) {
                case "namespace": {
                    if (hasDeclaration) {
                        throw lexer.failure(token, "Unexpected token 'namespace', expected type declaration", new Object[0]);
                    }
                    if (doc_string != null && !has_header) {
                        documentation = doc_string;
                    }
                    doc_string = null;
                    has_header = true;
                    this.parseNamespace(lexer, token, namespaces);
                    continue block22;
                }
                case "include": {
                    if (hasDeclaration) {
                        throw lexer.failure(token, "Unexpected token 'include', expected type declaration", new Object[0]);
                    }
                    if (doc_string != null && !has_header) {
                        documentation = doc_string;
                    }
                    doc_string = null;
                    has_header = true;
                    includes.add(this.parseInclude(lexer, token, includedPrograms, file.getParent()));
                    continue block22;
                }
                case "typedef": {
                    has_header = true;
                    hasDeclaration = true;
                    declarations.add(this.parseTypedef(lexer, token, doc_string));
                    doc_string = null;
                    continue block22;
                }
                case "enum": {
                    has_header = true;
                    hasDeclaration = true;
                    declarations.add(this.parseEnum(lexer, token, doc_string));
                    doc_string = null;
                    continue block22;
                }
                case "interface": {
                    if (!this.allowProvidenceOnlyFeatures) {
                        throw lexer.failure(token, "Interfaces not allowed in .thrift files", new Object[0]);
                    }
                }
                case "struct": 
                case "union": 
                case "exception": {
                    has_header = true;
                    hasDeclaration = true;
                    declarations.add(this.parseMessage(lexer, token, doc_string));
                    doc_string = null;
                    continue block22;
                }
                case "service": {
                    has_header = true;
                    hasDeclaration = true;
                    declarations.add(this.parseService(lexer, token, doc_string));
                    doc_string = null;
                    continue block22;
                }
                case "const": {
                    has_header = true;
                    hasDeclaration = true;
                    declarations.add(this.parseConst(lexer, token, doc_string));
                    doc_string = null;
                    continue block22;
                }
            }
            throw lexer.failure(token, "Unexpected token '%s'", new Object[]{Strings.escape((CharSequence)token.toString())});
        }
        return new ProgramDeclaration(documentation, programName, includes, namespaces, declarations);
    }

    private ServiceDeclaration parseService(ThriftLexer tokenizer, ThriftToken serviceToken, String documentation) throws IOException {
        ThriftToken name = (ThriftToken)tokenizer.expect("service name", ThriftToken::isIdentifier);
        if (this.forbiddenNameIdentifier(name.toString())) {
            throw tokenizer.failure(name, "Service with reserved name: " + (Object)((Object)name), new Object[0]);
        }
        ThriftToken extending = null;
        ThriftToken next = (ThriftToken)tokenizer.expect("service start or extends");
        if (next.toString().equals("extends")) {
            extending = (ThriftToken)tokenizer.expect("extending type", ThriftToken::isReferenceIdentifier);
            next = (ThriftToken)tokenizer.expectSymbol("service start", new char[]{'{'});
        }
        String doc_string = null;
        ArrayList<MethodDeclaration> functions = new ArrayList<MethodDeclaration>();
        next = (ThriftToken)tokenizer.expect("function or service end");
        while (!next.isSymbol('}')) {
            if (next.type() == ThriftTokenType.DOCUMENTATION) {
                doc_string = next.parseDocumentation();
                next = (ThriftToken)tokenizer.expect("function or service end");
                continue;
            }
            functions.add(this.parseMethod(tokenizer, next, doc_string));
            next = (ThriftToken)tokenizer.expect("function or service end");
        }
        List<AnnotationDeclaration> annotations = null;
        if (tokenizer.hasNext() && ((ThriftToken)tokenizer.peek("next")).isSymbol('(')) {
            tokenizer.next();
            annotations = this.parseAnnotations(tokenizer);
        }
        if (tokenizer.hasNext() && ((ThriftToken)tokenizer.peek("next")).isSymbol(';')) {
            tokenizer.next();
        }
        return new ServiceDeclaration(documentation, serviceToken, name, extending, functions, annotations);
    }

    private MethodDeclaration parseMethod(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken next, @Nullable String documentation) throws IOException {
        ThriftToken oneway = null;
        if (next.toString().equals("oneway")) {
            oneway = next;
            next = (ThriftToken)lexer.expect("method return type");
        }
        List<ThriftToken> returnType = this.parseType(lexer, next);
        ThriftToken name = (ThriftToken)lexer.expect("method name", ThriftToken::isIdentifier);
        ArrayList<FieldDeclaration> params = new ArrayList<FieldDeclaration>();
        lexer.expectSymbol("params start", new char[]{'('});
        next = (ThriftToken)lexer.expect("param or params end");
        String doc_string = null;
        AtomicInteger nextParamId = new AtomicInteger(-1);
        ThriftToken requestType = null;
        while (!next.isSymbol(')')) {
            if (next.type() == ThriftTokenType.DOCUMENTATION) {
                doc_string = next.parseDocumentation();
                next = (ThriftToken)lexer.expect("param or params end");
                continue;
            }
            if (this.allowProvidenceOnlyFeatures && next.isReferenceIdentifier() && ((ThriftToken)lexer.peek("after reference")).isSymbol(')')) {
                params = null;
                requestType = next;
                if (ThriftConstants.kThriftKeywords.contains(next.toString()) || ThriftConstants.kProvidenceKeywords.contains(next.toString())) {
                    if (PPrimitive.findByName((String)next.toString()) != null) {
                        throw new ThriftException(requestType, "Primitive type not allowed as request type on stubs", new Object[0]);
                    }
                    throw new ThriftException(requestType, "Not allowed as request type, reserved word", new Object[0]);
                }
                lexer.next();
                break;
            }
            params.add(this.parseField(lexer, next, nextParamId, doc_string, false));
            doc_string = null;
            next = (ThriftToken)lexer.expect("param or params end");
        }
        ArrayList<FieldDeclaration> throwing = new ArrayList<FieldDeclaration>();
        if (((ThriftToken)lexer.peek("throws or service end")).toString().equals("throws")) {
            lexer.next();
            lexer.expectSymbol("params start", new char[]{'('});
            next = (ThriftToken)lexer.expect("param or params end");
            nextParamId.set(-1);
            doc_string = null;
            while (!next.isSymbol(')')) {
                if (next.type() == ThriftTokenType.DOCUMENTATION) {
                    doc_string = next.parseDocumentation();
                    next = (ThriftToken)lexer.expect("param or params end");
                    continue;
                }
                throwing.add(this.parseField(lexer, next, nextParamId, doc_string, false));
                doc_string = null;
                next = (ThriftToken)lexer.expect("param or params end");
            }
        }
        List<AnnotationDeclaration> annotations = null;
        if (((ThriftToken)lexer.peek("annotation or service end")).isSymbol('(')) {
            lexer.next();
            annotations = this.parseAnnotations(lexer);
        }
        if (((ThriftToken)lexer.peek("function or service end")).isSymbol(';')) {
            lexer.next();
        }
        return new MethodDeclaration(documentation, oneway, returnType, name, params, requestType, throwing, annotations);
    }

    private void parseNamespace(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken namespaceToken, @Nonnull List<NamespaceDeclaration> namespaces) throws IOException {
        ThriftToken language = (ThriftToken)lexer.expect("namespace language", ThriftToken::isReferenceIdentifier);
        if (namespaces.stream().anyMatch(ns -> ns.getLanguage().equals(language.toString()))) {
            throw lexer.failure(language, "Namespace for %s already defined.", new Object[]{language.toString()});
        }
        ThriftToken namespace = (ThriftToken)lexer.expect("namespace", t -> VALID_NAMESPACE.matcher((CharSequence)((Object)t)).matches());
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol(';')) {
            lexer.next();
        }
        namespaces.add(new NamespaceDeclaration(namespaceToken, language, namespace));
    }

    private IncludeDeclaration parseInclude(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken includeToken, @Nonnull Set<String> includedPrograms, @Nonnull Path directory) throws IOException {
        String includedProgram;
        ThriftToken include = (ThriftToken)lexer.expect("include file", ThriftTokenType.STRING);
        String filePath = include.decodeString(true);
        Path path = Paths.get(filePath, new String[0]);
        if (!ReflectionUtils.isThriftBasedFileSyntax(path) || !this.allowProvidenceOnlyFeatures && !ReflectionUtils.isApacheThriftFile(path)) {
            throw lexer.failure(include, "Include not valid for thrift files " + filePath, new Object[0]);
        }
        if (!Files.exists(directory.resolve(filePath), new LinkOption[0])) {
            throw lexer.failure(include, "Included file not found " + filePath, new Object[0]);
        }
        ThriftToken includedProgramToken = null;
        if (this.allowProvidenceOnlyFeatures && lexer.hasNext() && ((ThriftToken)lexer.peek("next")).toString().equals("as")) {
            lexer.next();
            includedProgramToken = (ThriftToken)lexer.expect("included program name alias", ThriftToken::isIdentifier);
            includedProgram = includedProgramToken.toString();
        } else {
            includedProgram = ReflectionUtils.programNameFromPath(path);
        }
        if (includedPrograms.contains(includedProgram)) {
            throw lexer.failure(include, "thrift program '" + includedProgram + "' already included", new Object[0]);
        }
        includedPrograms.add(includedProgram);
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol(';')) {
            lexer.next();
        }
        return new IncludeDeclaration(includeToken, include, includedProgramToken);
    }

    private TypedefDeclaration parseTypedef(@Nonnull ThriftLexer tokenizer, @Nonnull ThriftToken typedefToken, @Nullable String documentation) throws IOException {
        List<ThriftToken> type = this.parseType(tokenizer, (ThriftToken)tokenizer.expect("typename"));
        ThriftToken name = (ThriftToken)tokenizer.expect("typedef identifier", ThriftToken::isIdentifier);
        if (this.forbiddenNameIdentifier(name.toString())) {
            throw tokenizer.failure(name, "Typedef with reserved name: " + (Object)((Object)name), new Object[0]);
        }
        if (tokenizer.hasNext() && ((ThriftToken)tokenizer.peek("next")).isSymbol(';')) {
            tokenizer.next();
        }
        return new TypedefDeclaration(documentation, typedefToken, name, type);
    }

    private EnumDeclaration parseEnum(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken enumToken, @Nullable String documentation) throws IOException {
        ThriftToken name = (ThriftToken)lexer.expect("enum name", ThriftToken::isIdentifier);
        if (this.forbiddenNameIdentifier(name.toString())) {
            throw lexer.failure(name, "Enum with reserved name: %s", new Object[]{name});
        }
        lexer.expectSymbol("enum start", new char[]{'{'});
        ArrayList<EnumValueDeclaration> values = new ArrayList<EnumValueDeclaration>();
        int nextAutoId = 0;
        String doc_string = null;
        ThriftToken next = (ThriftToken)lexer.expect("enum value or end");
        while (!next.isSymbol('}')) {
            int id;
            if (next.type() == ThriftTokenType.DOCUMENTATION) {
                doc_string = next.parseDocumentation();
                next = (ThriftToken)lexer.expect("enum value or end");
                continue;
            }
            ThriftToken valueName = next;
            ThriftToken valueId = null;
            next = (ThriftToken)lexer.expect("enum value sep or end");
            if (next.isSymbol('=')) {
                valueId = (ThriftToken)lexer.expect("enum value id", ThriftToken::isEnumValueId);
                next = (ThriftToken)lexer.expect("enum value or end");
            }
            if (this.requireEnumValue && valueId == null) {
                throw lexer.failure(valueName, "Explicit enum value required, but missing", new Object[0]);
            }
            List<AnnotationDeclaration> annotations = null;
            if (next.isSymbol('(')) {
                annotations = this.parseAnnotations(lexer);
                next = (ThriftToken)lexer.expect("enum value or end");
            }
            if (next.isSymbol(',') || next.isSymbol(';')) {
                next = (ThriftToken)lexer.expect("enum value or end");
            }
            if (valueId != null) {
                id = (int)valueId.parseInteger();
                nextAutoId = Math.max(id + 1, nextAutoId);
            } else {
                id = nextAutoId++;
            }
            values.add(new EnumValueDeclaration(doc_string, valueName, valueId, id, annotations));
            doc_string = null;
        }
        List<AnnotationDeclaration> annotations = null;
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol('(')) {
            lexer.next();
            annotations = this.parseAnnotations(lexer);
        }
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol(';')) {
            lexer.next();
        }
        return new EnumDeclaration(documentation, enumToken, name, values, annotations);
    }

    private MessageDeclaration parseMessage(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken variant, @Nullable String documentation) throws IOException {
        ThriftToken implementing = null;
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
        boolean union = variant.toString().equals("union");
        boolean struct = variant.toString().equals("struct");
        boolean iFace = variant.toString().equals("interface");
        ThriftToken name = (ThriftToken)lexer.expect("message name identifier", ThriftToken::isIdentifier);
        if (this.forbiddenNameIdentifier(name.toString())) {
            throw lexer.failure(name, "Message with reserved name: %s", new Object[]{name});
        }
        ThriftToken next = (ThriftToken)lexer.expect("message start");
        if (!next.isSymbol('{')) {
            if (!this.allowProvidenceOnlyFeatures) {
                throw lexer.failure(next, "Expected message start, got '%s'", new Object[]{Strings.escape((CharSequence)((Object)next))});
            }
            if (struct && next.toString().equals("implements")) {
                implementing = (ThriftToken)lexer.expect("implementing type", ThriftToken::isReferenceIdentifier);
            } else if (union && next.toString().equals("of")) {
                implementing = (ThriftToken)lexer.expect("union of type", ThriftToken::isReferenceIdentifier);
            } else {
                if (union) {
                    throw lexer.failure(next, "Expected message start, or union 'of', got '%s'", new Object[]{Strings.escape((CharSequence)next.toString())});
                }
                if (struct) {
                    throw lexer.failure(next, "Expected message start, or 'implements', got '%s'", new Object[]{Strings.escape((CharSequence)next.toString())});
                }
                throw lexer.failure(next, "Expected message start, got '%s'", new Object[]{Strings.escape((CharSequence)next.toString())});
            }
            lexer.expectSymbol("message start", new char[]{'{'});
        }
        AtomicInteger nextAutoId = new AtomicInteger(-1);
        String doc_string = null;
        next = (ThriftToken)lexer.expect("field def or message end");
        while (!next.isSymbol('}')) {
            if (next.type() == ThriftTokenType.DOCUMENTATION) {
                doc_string = next.parseDocumentation();
                next = (ThriftToken)lexer.expect("field def or message end");
                continue;
            }
            fields.add(this.parseField(lexer, next, nextAutoId, doc_string, iFace));
            doc_string = null;
            next = (ThriftToken)lexer.expect("field def or message end");
        }
        List<AnnotationDeclaration> annotations = null;
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol('(')) {
            lexer.next();
            annotations = this.parseAnnotations(lexer);
        }
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol(';')) {
            lexer.next();
        }
        return new MessageDeclaration(documentation, variant, name, implementing, fields, annotations);
    }

    private FieldDeclaration parseField(ThriftLexer lexer, ThriftToken next, AtomicInteger nextAutoId, String documentation, boolean iFace) throws IOException {
        int fieldId;
        ThriftToken idToken = null;
        if (next.isFieldId()) {
            if (iFace) {
                throw lexer.failure(next, "Field id in interfaces not allowed", new Object[0]);
            }
            idToken = next;
            fieldId = (int)idToken.parseInteger();
            if (fieldId < 1) {
                throw lexer.failure(next, "Non-positive ", new Object[0]);
            }
            lexer.expectSymbol("field id sep", new char[]{':'});
            next = (ThriftToken)lexer.expect("field type");
        } else {
            if (this.requireFieldId && !iFace) {
                throw lexer.failure(next, "Field id required, but missing", new Object[0]);
            }
            fieldId = nextAutoId.getAndDecrement();
        }
        ThriftToken requirement = null;
        if (next.toString().equals("optional") || next.toString().equals("required")) {
            requirement = next;
            next = (ThriftToken)lexer.expect("field type");
        }
        List<ThriftToken> type = this.parseType(lexer, next);
        ThriftToken name = (ThriftToken)lexer.expect("field name", ThriftToken::isIdentifier);
        List<ThriftToken> defaultValue = null;
        List<AnnotationDeclaration> annotations = null;
        if (this.forbiddenNameIdentifier(name.toString())) {
            throw lexer.failure(name, "Field with reserved name: " + name.toString(), new Object[0]);
        }
        if (((ThriftToken)lexer.peek("field value")).isSymbol('=')) {
            lexer.next();
            defaultValue = this.parseValue(lexer);
        }
        if (((ThriftToken)lexer.peek("field annotation")).isSymbol('(')) {
            lexer.next();
            annotations = this.parseAnnotations(lexer);
        }
        if (((ThriftToken)lexer.peek("field sep")).isSymbol(',') || ((ThriftToken)lexer.peek("field sep")).isSymbol(';')) {
            lexer.next();
        }
        return new FieldDeclaration(documentation, idToken, fieldId, requirement, name, type, defaultValue, annotations);
    }

    private ConstDeclaration parseConst(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken constToken, @Nullable String documentation) throws IOException {
        List<ThriftToken> type = this.parseType(lexer, (ThriftToken)lexer.expect("const type"));
        ThriftToken name = (ThriftToken)lexer.expect("const name", ThriftToken::isIdentifier);
        if (this.forbiddenNameIdentifier(name.toString())) {
            throw lexer.failure(name, "Const with reserved name: " + name.toString(), new Object[0]);
        }
        lexer.expect("const value sep", t -> t.isSymbol('='));
        List<ThriftToken> value = this.parseValue(lexer);
        List<AnnotationDeclaration> annotations = null;
        if (this.allowProvidenceOnlyFeatures && lexer.hasNext() && ((ThriftToken)lexer.expect("next")).isSymbol('(')) {
            lexer.next();
            annotations = this.parseAnnotations(lexer);
        }
        if (lexer.hasNext() && ((ThriftToken)lexer.peek("next")).isSymbol(';')) {
            lexer.next();
        }
        return new ConstDeclaration(documentation, constToken, name, type, value, annotations);
    }

    private List<AnnotationDeclaration> parseAnnotations(@Nonnull ThriftLexer tokenizer) throws IOException {
        ArrayList<AnnotationDeclaration> annotations = new ArrayList<AnnotationDeclaration>();
        ThriftToken next = (ThriftToken)tokenizer.expect("annotation key");
        while (!next.isSymbol(')')) {
            if (!next.isReferenceIdentifier()) {
                throw tokenizer.failure(next, "annotation key must be identifier-like", new Object[0]);
            }
            ThriftToken key = next;
            ThriftToken value = null;
            next = (ThriftToken)tokenizer.expect("annotation end or sep");
            if (next.isSymbol('=')) {
                value = (ThriftToken)tokenizer.expect("annotation value", ThriftTokenType.STRING);
                next = (ThriftToken)tokenizer.expect("annotation end or sep");
            }
            annotations.add(new AnnotationDeclaration(key, value));
            if (!next.isSymbol(',')) continue;
            next = (ThriftToken)tokenizer.expect("annotation key", t -> !t.isSymbol(')'));
        }
        return annotations;
    }

    private List<ThriftToken> parseValue(@Nonnull ThriftLexer lexer) throws IOException {
        return this.parseValue(lexer, (ThriftToken)lexer.expect("value"));
    }

    private List<ThriftToken> parseValue(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken token) throws IOException {
        while (token.type() == ThriftTokenType.DOCUMENTATION) {
            token = (ThriftToken)lexer.expect("value");
        }
        ArrayList<ThriftToken> tokens = new ArrayList<ThriftToken>();
        tokens.add(token);
        if (token.isSymbol('[')) {
            ThriftToken next = (ThriftToken)lexer.expect("list value");
            while (!next.isSymbol(']')) {
                tokens.addAll(this.parseValue(lexer, next));
                next = (ThriftToken)lexer.expect("list value, sep or end");
                if (!next.isSymbol(',') && !next.isSymbol(';')) continue;
                tokens.add(next);
                next = (ThriftToken)lexer.expect("list value or end");
            }
            tokens.add(next);
        } else if (token.isSymbol('{')) {
            ThriftToken next = (ThriftToken)lexer.expect("map key");
            while (!next.isSymbol('}')) {
                tokens.addAll(this.parseValue(lexer, next));
                tokens.add((ThriftToken)lexer.expectSymbol("key value sep", new char[]{':'}));
                tokens.addAll(this.parseValue(lexer, (ThriftToken)lexer.expect("map value")));
                next = (ThriftToken)lexer.expect("map sep or end");
                if (!next.isSymbol(',') && !next.isSymbol(';')) continue;
                tokens.add(next);
                next = (ThriftToken)lexer.expect("map sep or end");
            }
            tokens.add(next);
        } else if (!token.isReferenceIdentifier() && token.type() != ThriftTokenType.NUMBER && token.type() != ThriftTokenType.STRING) {
            throw lexer.failure(token, "not a value type: '%s'", new Object[]{token.toString()});
        }
        return tokens;
    }

    private List<ThriftToken> parseType(@Nonnull ThriftLexer lexer, @Nonnull ThriftToken token) throws IOException {
        String type;
        if (!token.isQualifiedIdentifier() && !token.isIdentifier()) {
            throw lexer.failure(token, "Expected type identifier but found " + (Object)((Object)token), new Object[0]);
        }
        ArrayList<ThriftToken> tokens = new ArrayList<ThriftToken>();
        tokens.add(token);
        switch (type = token.toString()) {
            case "list": 
            case "set": {
                tokens.add((ThriftToken)lexer.expect(type + " generic start", t -> t.isSymbol('<')));
                tokens.addAll(this.parseType(lexer, (ThriftToken)lexer.expect(type + " item type")));
                tokens.add((ThriftToken)lexer.expect(type + " generic end", t -> t.isSymbol('>')));
                break;
            }
            case "map": {
                tokens.add((ThriftToken)lexer.expect(type + " generic start", t -> t.isSymbol('<')));
                tokens.addAll(this.parseType(lexer, (ThriftToken)lexer.expect(type + " key type")));
                tokens.add((ThriftToken)lexer.expect(type + " generic sep", t -> t.isSymbol(',')));
                tokens.addAll(this.parseType(lexer, (ThriftToken)lexer.expect(type + " item type")));
                tokens.add((ThriftToken)lexer.expect(type + " generic end", t -> t.isSymbol('>')));
            }
        }
        return tokens;
    }

    private boolean forbiddenNameIdentifier(String name) {
        if (ThriftConstants.kThriftKeywords.contains(name)) {
            return true;
        }
        if (this.allowProvidenceOnlyFeatures && ThriftConstants.kProvidenceKeywords.contains(name)) {
            return true;
        }
        return !this.allowLanguageReservedNames && ThriftConstants.kReservedWords.contains(name);
    }
}

