/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.model;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.reflect.model.AnnotationDeclaration;
import net.morimekta.providence.reflect.model.Declaration;
import net.morimekta.providence.reflect.model.DeclarationUtil;
import net.morimekta.providence.reflect.model.FieldDeclaration;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.util.collect.UnmodifiableList;

public class MethodDeclaration
extends Declaration {
    private final ThriftToken oneway;
    private final List<ThriftToken> returnTypeTokens;
    private final List<FieldDeclaration> params;
    private final ThriftToken requestTypeToken;
    private final List<FieldDeclaration> throwing;

    public MethodDeclaration(@Nullable String documentation, @Nullable ThriftToken oneway, @Nonnull List<ThriftToken> returnTypeTokens, @Nonnull ThriftToken name, @Nullable List<FieldDeclaration> params, @Nullable ThriftToken requestTypeToken, @Nullable List<FieldDeclaration> throwing, @Nullable List<AnnotationDeclaration> annotations) {
        super(documentation, name, annotations);
        if (requestTypeToken == null && params == null) {
            throw new IllegalArgumentException("Either request type or params must be non-null");
        }
        if (requestTypeToken != null && params != null) {
            throw new IllegalArgumentException("Only one of request type and params may be non-null");
        }
        this.oneway = oneway;
        this.returnTypeTokens = UnmodifiableList.copyOf(returnTypeTokens);
        this.requestTypeToken = requestTypeToken;
        this.params = requestTypeToken == null ? UnmodifiableList.copyOf(params) : null;
        this.throwing = throwing == null || throwing.isEmpty() ? null : UnmodifiableList.copyOf(throwing);
    }

    public boolean isOneWay() {
        return this.oneway != null;
    }

    @Nullable
    public ThriftToken getRequestTypeToken() {
        return this.requestTypeToken;
    }

    @Nullable
    public ThriftToken getOneWayToken() {
        return this.oneway;
    }

    @Nonnull
    public String getReturnType() {
        return DeclarationUtil.toTypeString(this.returnTypeTokens);
    }

    @Nonnull
    public List<ThriftToken> getReturnTypeTokens() {
        return this.returnTypeTokens;
    }

    @Nonnull
    public List<FieldDeclaration> getParams() {
        return this.params;
    }

    @Nullable
    public List<FieldDeclaration> getThrowing() {
        return this.throwing;
    }
}

