/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CInterfaceDescriptor;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.providence.reflect.contained.CStruct;
import net.morimekta.providence.serializer.json.JsonCompactibleDescriptor;
import net.morimekta.util.collect.UnmodifiableMap;

public class CStructDescriptor
extends PStructDescriptor<CStruct>
implements CMessageDescriptor,
JsonCompactibleDescriptor {
    public static final int MAX_COMPACT_FIELDS = 10;
    private final String comment;
    private final CField<CStruct>[] fields;
    private final Map<Integer, CField<CStruct>> fieldIdMap;
    private final Map<String, CField<CStruct>> fieldNameMap;
    private final Map<String, CField<CStruct>> fieldPojoNameMap;
    private final Map<String, String> annotations;
    private final boolean compactible;
    private final PDescriptorProvider implementing;
    private final boolean innerType;
    private final boolean autoType;

    public CStructDescriptor(String comment, String programName, String name, List<CField<CStruct>> fields, Map<String, String> annotations, PDescriptorProvider implementing) {
        super(programName, name, (Supplier)new _Factory(), false);
        ((_Factory)this.getBuilderSupplier()).setType(this);
        this.innerType = name.contains(".");
        this.autoType = this.innerType && name.indexOf(".") != name.lastIndexOf(".");
        this.comment = comment;
        this.fields = fields.toArray(CField.EMPTY_ARRAY);
        this.annotations = annotations;
        this.compactible = CStructDescriptor.isCompactCompatible(fields, annotations);
        UnmodifiableMap.Builder fieldIdMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldNameMap = UnmodifiableMap.builder((int)this.fields.length);
        UnmodifiableMap.Builder fieldPojoNameMap = UnmodifiableMap.builder((int)this.fields.length);
        for (CField<CStruct> field : fields) {
            field.setMessageType((PMessageDescriptor<CStruct>)this);
            fieldIdMap.put((Object)field.getId(), field);
            fieldNameMap.put((Object)field.getName(), field);
            fieldPojoNameMap.put((Object)field.getPojoName(), field);
        }
        this.fieldIdMap = fieldIdMap.build();
        this.fieldNameMap = fieldNameMap.build();
        this.fieldPojoNameMap = fieldPojoNameMap.build();
        this.implementing = implementing;
    }

    public boolean isInnerType() {
        return this.innerType;
    }

    public boolean isAutoType() {
        return this.autoType;
    }

    @Override
    public final String getDocumentation() {
        return this.comment;
    }

    @Nonnull
    public CField<CStruct>[] getFields() {
        return Arrays.copyOf(this.fields, this.fields.length);
    }

    @Override
    public CField<CStruct> findFieldByName(String name) {
        return this.fieldNameMap.get(name);
    }

    public CField<CStruct> findFieldByPojoName(String pojoName) {
        return this.fieldPojoNameMap.get(pojoName);
    }

    @Override
    public CField<CStruct> findFieldById(int id) {
        return this.fieldIdMap.get(id);
    }

    @Override
    @Nullable
    public CInterfaceDescriptor getImplementing() {
        if (this.implementing == null) {
            return null;
        }
        return (CInterfaceDescriptor)this.implementing.descriptor();
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations.keySet();
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.containsKey(name);
        }
        return false;
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        if (this.annotations != null) {
            return this.annotations.get(name);
        }
        return null;
    }

    @Override
    public boolean isSimple() {
        for (CField<CStruct> field : this.getFields()) {
            switch (field.getType()) {
                case MAP: 
                case SET: 
                case LIST: 
                case MESSAGE: {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isJsonCompactible() {
        return this.compactible;
    }

    private static boolean isCompactCompatible(List<CField<CStruct>> fields, Map<String, String> annotations) {
        if (annotations == null) {
            return false;
        }
        if (!annotations.containsKey(PAnnotation.JSON_COMPACT.tag) && !annotations.containsKey("compact")) {
            return false;
        }
        if (fields.size() > 10) {
            return false;
        }
        int next = 1;
        boolean hasOptional = false;
        for (CField<CStruct> field : fields) {
            if (field.getId() != next) {
                return false;
            }
            if (hasOptional && field.getRequirement() == PRequirement.REQUIRED) {
                return false;
            }
            if (field.getRequirement() == PRequirement.OPTIONAL) {
                hasOptional = true;
            }
            ++next;
        }
        return true;
    }

    private static class _Factory
    implements Supplier<PMessageBuilder<CStruct>> {
        private CStructDescriptor mType;

        private _Factory() {
        }

        public void setType(CStructDescriptor type) {
            this.mType = type;
        }

        @Override
        @Nonnull
        public PMessageBuilder<CStruct> get() {
            return new CStruct.Builder(this.mType);
        }
    }
}

