/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.contained;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.reflect.contained.CAnnotatedDescriptor;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;

public class CServiceMethod
implements PServiceMethod,
CAnnotatedDescriptor {
    private final String name;
    private final boolean oneway;
    private final boolean protoStub;
    private final CStructDescriptor requestType;
    private final CUnionDescriptor responseType;
    private final String comment;
    private final Map<String, String> annotations;
    private final PServiceProvider service;

    public CServiceMethod(String comment, String name, boolean oneway, boolean protoStub, CStructDescriptor requestType, CUnionDescriptor responseType, Map<String, String> annotations, PServiceProvider service) {
        this.comment = comment;
        this.name = name;
        this.oneway = oneway;
        this.protoStub = protoStub;
        this.requestType = requestType;
        this.responseType = responseType;
        this.annotations = annotations == null ? Collections.emptyMap() : annotations;
        this.service = service;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public boolean isProtoStub() {
        return this.protoStub;
    }

    @Nonnull
    public CStructDescriptor getRequestType() {
        return this.requestType;
    }

    public CUnionDescriptor getResponseType() {
        return this.responseType;
    }

    @Nonnull
    public PService getService() {
        return this.service.getService();
    }

    @Override
    @Nonnull
    public Set<String> getAnnotations() {
        return this.annotations.keySet();
    }

    @Override
    public boolean hasAnnotation(@Nonnull String name) {
        return this.annotations.containsKey(name);
    }

    @Override
    public String getAnnotationValue(@Nonnull String name) {
        return this.annotations.get(name);
    }

    @Override
    public String getDocumentation() {
        return this.comment;
    }

    public int hashCode() {
        return Objects.hash(CServiceMethod.class, this.name, this.oneway, this.responseType, this.requestType, this.comment, this.annotations);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        CServiceMethod other = (CServiceMethod)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.oneway, other.oneway) && Objects.equals(this.responseType, other.responseType) && Objects.equals(this.requestType, other.requestType) && Objects.equals(this.comment, other.comment) && Objects.equals(this.annotations, other.annotations);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceMethod(");
        if (this.oneway) {
            builder.append("oneway ");
        }
        if (this.responseType != null) {
            builder.append(this.responseType.fieldForId(0).getDescriptor().getQualifiedName());
        } else {
            builder.append("void");
        }
        builder.append(" ");
        builder.append(this.name);
        builder.append("([");
        builder.append(this.requestType.getQualifiedName());
        builder.append("])");
        return builder.toString();
    }
}

