package net.morimekta.providence.reflect.parser;

import net.morimekta.util.collect.UnmodifiableSet;

/**
 * Reflective thrift IDL description.
 * <p>
 * Comments are gathered before the start of the next statement.
 * <p>
 * - Line comments are accumulated with newline delimiter.
 *   Each line is individually trimmed.
 * - Block comments replace the entire comment.
 *   The first space after &#39;*&#39; on each line is ignored.
 */
public class ThriftConstants {
    private ThriftConstants() {}

    public static final java.util.Set<String> kThriftKeywords = UnmodifiableSet.<String>builder()
            .add("include")
            .add("namespace")
            .add("bool")
            .add("byte")
            .add("i8")
            .add("i16")
            .add("i32")
            .add("i64")
            .add("double")
            .add("string")
            .add("binary")
            .add("list")
            .add("set")
            .add("map")
            .add("enum")
            .add("struct")
            .add("union")
            .add("exception")
            .add("const")
            .add("typedef")
            .add("service")
            .add("required")
            .add("optional")
            .add("extends")
            .add("throws")
            .add("oneway")
            .add("void")
            .build();

    public static final java.util.Set<String> kProvidenceKeywords = UnmodifiableSet.<String>builder()
            .add("interface")
            .add("implements")
            .add("of")
            .build();

    public static final java.util.Set<String> kReservedWords = UnmodifiableSet.<String>builder()
            .add("abstract")
            .add("alias")
            .add("and")
            .add("args")
            .add("as")
            .add("assert")
            .add("begin")
            .add("break")
            .add("case")
            .add("catch")
            .add("class")
            .add("clone")
            .add("continue")
            .add("declare")
            .add("def")
            .add("default")
            .add("del")
            .add("delete")
            .add("do")
            .add("dynamic")
            .add("elif")
            .add("else")
            .add("elseif")
            .add("elsif")
            .add("end")
            .add("enddeclare")
            .add("endfor")
            .add("endforeach")
            .add("endif")
            .add("endswitch")
            .add("endwhile")
            .add("ensure")
            .add("except")
            .add("exec")
            .add("finally")
            .add("float")
            .add("for")
            .add("foreach")
            .add("from")
            .add("function")
            .add("global")
            .add("goto")
            .add("if")
            .add("implements")
            .add("import")
            .add("in")
            .add("inline")
            .add("instanceof")
            .add("interface")
            .add("is")
            .add("int")
            .add("lambda")
            .add("long")
            .add("module")
            .add("native")
            .add("new")
            .add("next")
            .add("nil")
            .add("not")
            .add("or")
            .add("package")
            .add("pass")
            .add("public")
            .add("print")
            .add("private")
            .add("protected")
            .add("raise")
            .add("redo")
            .add("rescue")
            .add("retry")
            .add("register")
            .add("return")
            .add("self")
            .add("short")
            .add("sizeof")
            .add("static")
            .add("super")
            .add("switch")
            .add("synchronized")
            .add("then")
            .add("this")
            .add("throw")
            .add("transient")
            .add("try")
            .add("undef")
            .add("unless")
            .add("unsigned")
            .add("until")
            .add("use")
            .add("var")
            .add("virtual")
            .add("volatile")
            .add("when")
            .add("while")
            .add("with")
            .add("xor")
            .add("yield")
            .build();
}
