/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.morimekta.providence.PEnumBuilder;
import net.morimekta.providence.PEnumValue;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageBuilder;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PList;
import net.morimekta.providence.descriptor.PMap;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PSet;
import net.morimekta.providence.descriptor.PValueProvider;
import net.morimekta.providence.reflect.parser.ThriftException;
import net.morimekta.providence.reflect.parser.ThriftLexer;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.parser.ThriftTokenType;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.providence.types.TypeRegistry;
import net.morimekta.providence.util.MessageUtil;
import net.morimekta.util.Binary;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.collect.UnmodifiableSet;
import net.morimekta.util.json.JsonException;
import net.morimekta.util.json.JsonToken;
import net.morimekta.util.json.JsonTokenizer;
import net.morimekta.util.lexer.LexerException;
import net.morimekta.util.lexer.Tokenizer;
import net.morimekta.util.lexer.TokenizerRepeater;
import net.morimekta.util.lexer.UncheckedLexerException;

public class ConstValueProvider
implements PValueProvider<Object> {
    private final TypeRegistry registry;
    private final String programName;
    private final TypeReference constType;
    private final List<ThriftToken> constTokens;
    private AtomicReference<Object> parsedValue;

    public ConstValueProvider(@Nonnull TypeRegistry registry, @Nonnull String programName, @Nonnull TypeReference constType, @Nonnull List<ThriftToken> constTokens) {
        this.registry = registry;
        this.programName = programName;
        this.constType = constType;
        this.constTokens = constTokens;
        this.parsedValue = null;
    }

    public Object get() {
        if (this.parsedValue == null) {
            PDescriptor type = this.registry.getTypeProvider(this.constType, Collections.emptyMap()).descriptor();
            TokenizerRepeater tokenizer = new TokenizerRepeater(this.constTokens);
            ThriftLexer lexer = new ThriftLexer((Tokenizer<ThriftTokenType, ThriftToken>)tokenizer);
            try {
                this.parsedValue = new AtomicReference<Object>(this.parseTypedValue((ThriftToken)lexer.expect("const value"), lexer, type, true));
            }
            catch (LexerException e) {
                throw new UncheckedLexerException(e);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }
        return this.parsedValue.get();
    }

    private <Message extends PMessage<Message>> Message parseMessage(ThriftLexer lexer, PMessageDescriptor<Message> type) throws IOException {
        PMessageBuilder builder = type.builder();
        ThriftToken token = (ThriftToken)lexer.expect("message field or end");
        while (!token.isSymbol('}')) {
            if (token.type() != ThriftTokenType.STRING) {
                throw lexer.failure(token, "Invalid field name token", new Object[0]);
            }
            PField field = type.findFieldByName(token.decodeString(true));
            if (field == null) {
                throw lexer.failure(token, "No such field in %s: %s", new Object[]{type.getQualifiedName(), token.decodeString(true)});
            }
            lexer.expectSymbol("message key-value sep", new char[]{':'});
            builder.set(field.getId(), this.parseTypedValue((ThriftToken)lexer.expect("parsing field value"), lexer, field.getDescriptor(), false));
            token = (ThriftToken)lexer.expect("message sep, field or end");
            if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
            token = (ThriftToken)lexer.expect("message field or end");
        }
        return (Message)builder.build();
    }

    private Object parseTypedValue(ThriftToken token, ThriftLexer lexer, PDescriptor valueType, boolean allowNull) throws IOException {
        if (token.isQualifiedIdentifier() || token.isDoubleQualifiedIdentifier()) {
            Optional desc;
            String typeName = token.toString().replaceAll("\\.[^.]+$", "");
            if (typeName.equals(valueType.getName()) && valueType.getType() == PType.ENUM) {
                desc = Optional.of((PDeclaredDescriptor)valueType);
            } else {
                TypeReference ref = TypeReference.parseType((String)this.programName, (String)typeName);
                desc = this.registry.getDeclaredType(ref);
            }
            if (desc.isPresent()) {
                if (!(desc.get() instanceof PEnumDescriptor)) {
                    throw new IllegalArgumentException("Not an enum type " + ((PDeclaredDescriptor)desc.get()).getQualifiedName());
                }
                String valueName = token.toString().replaceAll("^.*\\.", "");
                PEnumValue value = ((PEnumDescriptor)desc.get()).findByName(valueName);
                if (value != null) {
                    return MessageUtil.coerceStrict((PDescriptor)valueType, (Object)value).orElseThrow(() -> new IllegalArgumentException("Non-matching enum value"));
                }
                if (allowNull) {
                    return null;
                }
                throw new IllegalArgumentException("No such " + ((PDeclaredDescriptor)desc.get()).getQualifiedName() + " value " + valueName);
            }
        }
        if (token.isIdentifier() || token.isQualifiedIdentifier()) {
            if ("null".equals(token.toString()) && allowNull) {
                return null;
            }
            Optional optional = this.registry.getConstantValue(TypeReference.parseType((String)this.programName, (String)token.toString()));
            if (optional.isPresent()) {
                return MessageUtil.coerceStrict((PDescriptor)valueType, optional.get()).orElse(null);
            }
        }
        switch (valueType.getType()) {
            case BOOL: {
                if (token.isIdentifier()) {
                    return Boolean.parseBoolean(token.toString());
                }
                if (token.isInteger()) {
                    return token.parseInteger() != 0L;
                }
                throw lexer.failure(token, "Not boolean value: %s", new Object[]{token.toString()});
            }
            case BYTE: {
                if (token.isInteger()) {
                    return (byte)token.parseInteger();
                }
                return (byte)this.findEnumValue(token.toString(), token, lexer, "byte");
            }
            case I16: {
                if (token.isInteger()) {
                    return (short)token.parseInteger();
                }
                return (short)this.findEnumValue(token.toString(), token, lexer, "i16");
            }
            case I32: {
                if (token.isInteger()) {
                    return (int)token.parseInteger();
                }
                return this.findEnumValue(token.toString(), token, lexer, "i32");
            }
            case I64: {
                if (token.isInteger()) {
                    return token.parseInteger();
                }
                return (long)this.findEnumValue(token.toString(), token, lexer, "i64");
            }
            case DOUBLE: {
                if (token.type() == ThriftTokenType.NUMBER) {
                    return token.parseDouble();
                }
                throw lexer.failure(token, (Object)((Object)token) + " is not a valid double value.", new Object[0]);
            }
            case STRING: {
                if (token.type() == ThriftTokenType.STRING) {
                    return token.decodeString(true);
                }
                if (allowNull && token.toString().equals("null")) {
                    return null;
                }
                throw lexer.failure(token, "Not a valid string value.", new Object[0]);
            }
            case BINARY: {
                if (token.type() == ThriftTokenType.STRING) {
                    return this.parseBinary(token.substring(1, -1).toString());
                }
                if (allowNull && token.toString().equals("null")) {
                    return null;
                }
                throw lexer.failure(token, "Not a valid binary value.", new Object[0]);
            }
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)valueType).builder();
                String name = token.toString();
                if (Strings.isInteger((CharSequence)name)) {
                    Object ev = eb.setById(Integer.parseInt(name)).build();
                    if (ev == null) {
                        if (allowNull && token.toString().equals("null")) {
                            return null;
                        }
                        throw lexer.failure(token, "No such " + valueType.getQualifiedName() + " enum value \"" + name, new Object[0]);
                    }
                    return ev;
                }
                throw lexer.failure(token, "Not valid enum reference '" + name + "'", new Object[0]);
            }
            case MESSAGE: {
                if (token.isSymbol('{')) {
                    return this.parseMessage(lexer, (PMessageDescriptor)valueType);
                }
                if (allowNull && token.toString().equals("null")) {
                    return null;
                }
                throw lexer.failure(token, "Not a valid message start.", new Object[0]);
            }
            case LIST: {
                PDescriptor itemType = ((PList)valueType).itemDescriptor();
                UnmodifiableList.Builder list = UnmodifiableList.builder();
                if (!token.isSymbol('[')) {
                    throw lexer.failure(token, "Expected list start, found " + token.toString(), new Object[0]);
                }
                token = (ThriftToken)lexer.expect("list item or end");
                while (!token.isSymbol(']')) {
                    list.add(this.parseTypedValue(token, lexer, itemType, false));
                    token = (ThriftToken)lexer.expect("list item, sep or end");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    token = (ThriftToken)lexer.expect("list item or end");
                }
                return list.build();
            }
            case SET: {
                PDescriptor itemType = ((PSet)valueType).itemDescriptor();
                UnmodifiableSet.Builder set = UnmodifiableSet.builder();
                if (!token.isSymbol('[')) {
                    throw lexer.failure(token, "Expected list start, found " + token.toString(), new Object[0]);
                }
                if (!token.isSymbol('[')) {
                    throw lexer.failure(token, "Expected list start, found " + token.toString(), new Object[0]);
                }
                token = (ThriftToken)lexer.expect("list item or end");
                while (!token.isSymbol(']')) {
                    set.add(this.parseTypedValue(token, lexer, itemType, false));
                    token = (ThriftToken)lexer.expect("list item, sep or end");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    token = (ThriftToken)lexer.expect("list item or end");
                }
                return set.build();
            }
            case MAP: {
                PDescriptor itemType = ((PMap)valueType).itemDescriptor();
                PDescriptor keyType = ((PMap)valueType).keyDescriptor();
                UnmodifiableMap.Builder map = UnmodifiableMap.builder();
                if (!token.isSymbol('{')) {
                    throw lexer.failure(token, "Expected map start, found " + token.toString(), new Object[0]);
                }
                token = (ThriftToken)lexer.expect("map key or end");
                while (!token.isSymbol('}')) {
                    Object key;
                    if (token.type() == ThriftTokenType.STRING) {
                        key = this.parsePrimitiveKey(token.decodeString(true), token, lexer, keyType);
                    } else if (token.isIdentifier() || token.isQualifiedIdentifier()) {
                        key = this.registry.getConstantValue(TypeReference.parseType((String)this.programName, (String)token.toString())).orElse(null);
                        if (key == null) {
                            if (keyType.getType().equals((Object)PType.STRING) || keyType.getType().equals((Object)PType.BINARY)) {
                                throw lexer.failure(token, "Expected string literal for string key", new Object[0]);
                            }
                            key = this.parsePrimitiveKey(token.toString(), token, lexer, keyType);
                        }
                    } else {
                        if (keyType.getType().equals((Object)PType.STRING) || keyType.getType().equals((Object)PType.BINARY)) {
                            throw lexer.failure(token, "Expected string literal for string key", new Object[0]);
                        }
                        key = this.parsePrimitiveKey(token.toString(), token, lexer, keyType);
                    }
                    lexer.expectSymbol("map KV separator", new char[]{':'});
                    map.put(key, this.parseTypedValue((ThriftToken)lexer.expect("map value"), lexer, itemType, false));
                    token = (ThriftToken)lexer.expect("map key, sep or end");
                    if (!token.isSymbol(',') && !token.isSymbol(';')) continue;
                    token = (ThriftToken)lexer.expect("map key or end");
                }
                return map.build();
            }
        }
        throw new IllegalArgumentException("Unhandled item type " + valueType.getQualifiedName());
    }

    private Object parsePrimitiveKey(String key, ThriftToken token, ThriftLexer tokenizer, PDescriptor keyType) throws IOException {
        switch (keyType.getType()) {
            case ENUM: {
                PEnumBuilder eb = ((PEnumDescriptor)keyType).builder();
                if (Strings.isInteger((CharSequence)key)) {
                    return eb.setById(Integer.parseInt(key)).build();
                }
                if (key.startsWith(keyType.getProgramName() + "." + keyType.getName() + ".")) {
                    key = key.substring(keyType.getProgramName().length() + keyType.getName().length() + 2);
                } else if (key.startsWith(keyType.getName() + ".")) {
                    key = key.substring(keyType.getName().length() + 1);
                }
                return eb.setByName(key).build();
            }
            case BOOL: {
                return Boolean.parseBoolean(key);
            }
            case BYTE: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Byte.parseByte(key);
                }
                return (byte)this.findEnumValue(key, token, tokenizer, "byte");
            }
            case I16: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Short.parseShort(key);
                }
                return (short)this.findEnumValue(key, token, tokenizer, "i16");
            }
            case I32: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Integer.parseInt(key);
                }
                return this.findEnumValue(key, token, tokenizer, "i32");
            }
            case I64: {
                if (Strings.isInteger((CharSequence)key)) {
                    return Long.parseLong(key);
                }
                return (long)this.findEnumValue(key, token, tokenizer, "i64");
            }
            case DOUBLE: {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(key.getBytes(StandardCharsets.US_ASCII));
                    JsonTokenizer tokener = new JsonTokenizer((InputStream)bais);
                    JsonToken jt = tokener.expect("parsing double value");
                    return jt.doubleValue();
                }
                catch (IOException | NumberFormatException | JsonException e) {
                    throw new ThriftException(token, "Unable to parse double value", new Object[0]).initCause(e);
                }
            }
            case STRING: {
                return key;
            }
            case BINARY: {
                return this.parseBinary(key);
            }
        }
        throw new ThriftException("Illegal key type: " + keyType.getType(), new Object[0]);
    }

    private int findEnumValue(String identifier, ThriftToken token, ThriftLexer tokenizer, String expectedType) throws IOException {
        String valueName;
        String typeName;
        String[] parts = identifier.split("\\.", 127);
        if (parts.length == 3) {
            typeName = parts[0] + "." + parts[1];
            valueName = parts[2];
        } else if (parts.length == 2) {
            typeName = parts[0];
            valueName = parts[1];
        } else {
            throw tokenizer.failure(token, identifier + " is not a valid " + expectedType + " value.", new Object[0]);
        }
        try {
            PEnumDescriptor desc;
            PEnumValue value;
            PDeclaredDescriptor descriptor = this.registry.requireDeclaredType(TypeReference.parseType((String)this.programName, (String)typeName));
            if (descriptor instanceof PEnumDescriptor && (value = (desc = (PEnumDescriptor)descriptor).findByName(valueName)) != null) {
                return value.asInteger();
            }
            throw tokenizer.failure(token, typeName + " is not an enum.", new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw tokenizer.failure(token, "No type named " + typeName + ".", new Object[0]);
        }
    }

    private Binary parseBinary(String value) {
        return Binary.fromBase64((String)value);
    }
}

