/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.morimekta.providence.PMessage;
import net.morimekta.providence.PMessageVariant;
import net.morimekta.providence.PType;
import net.morimekta.providence.descriptor.PAnnotation;
import net.morimekta.providence.descriptor.PDeclaredDescriptor;
import net.morimekta.providence.descriptor.PDescriptor;
import net.morimekta.providence.descriptor.PDescriptorProvider;
import net.morimekta.providence.descriptor.PEnumDescriptor;
import net.morimekta.providence.descriptor.PField;
import net.morimekta.providence.descriptor.PMessageDescriptor;
import net.morimekta.providence.descriptor.PPrimitive;
import net.morimekta.providence.descriptor.PRequirement;
import net.morimekta.providence.descriptor.PService;
import net.morimekta.providence.descriptor.PServiceMethod;
import net.morimekta.providence.descriptor.PServiceProvider;
import net.morimekta.providence.descriptor.PStructDescriptor;
import net.morimekta.providence.descriptor.PStructDescriptorProvider;
import net.morimekta.providence.reflect.GlobalRegistry;
import net.morimekta.providence.reflect.ProgramRegistry;
import net.morimekta.providence.reflect.contained.CConst;
import net.morimekta.providence.reflect.contained.CEnumDescriptor;
import net.morimekta.providence.reflect.contained.CEnumValue;
import net.morimekta.providence.reflect.contained.CException;
import net.morimekta.providence.reflect.contained.CExceptionDescriptor;
import net.morimekta.providence.reflect.contained.CField;
import net.morimekta.providence.reflect.contained.CInterface;
import net.morimekta.providence.reflect.contained.CInterfaceDescriptor;
import net.morimekta.providence.reflect.contained.CMessageDescriptor;
import net.morimekta.providence.reflect.contained.CProgram;
import net.morimekta.providence.reflect.contained.CService;
import net.morimekta.providence.reflect.contained.CServiceMethod;
import net.morimekta.providence.reflect.contained.CStruct;
import net.morimekta.providence.reflect.contained.CStructDescriptor;
import net.morimekta.providence.reflect.contained.CUnion;
import net.morimekta.providence.reflect.contained.CUnionDescriptor;
import net.morimekta.providence.reflect.model.AnnotationDeclaration;
import net.morimekta.providence.reflect.model.ConstDeclaration;
import net.morimekta.providence.reflect.model.Declaration;
import net.morimekta.providence.reflect.model.EnumDeclaration;
import net.morimekta.providence.reflect.model.EnumValueDeclaration;
import net.morimekta.providence.reflect.model.FieldDeclaration;
import net.morimekta.providence.reflect.model.IncludeDeclaration;
import net.morimekta.providence.reflect.model.MessageDeclaration;
import net.morimekta.providence.reflect.model.MethodDeclaration;
import net.morimekta.providence.reflect.model.NamespaceDeclaration;
import net.morimekta.providence.reflect.model.ProgramDeclaration;
import net.morimekta.providence.reflect.model.ServiceDeclaration;
import net.morimekta.providence.reflect.model.TypedefDeclaration;
import net.morimekta.providence.reflect.parser.ThriftException;
import net.morimekta.providence.reflect.parser.ThriftParser;
import net.morimekta.providence.reflect.parser.ThriftToken;
import net.morimekta.providence.reflect.util.ConstValueProvider;
import net.morimekta.providence.reflect.util.ReflectionUtils;
import net.morimekta.providence.types.TypeReference;
import net.morimekta.providence.types.TypeRegistry;
import net.morimekta.util.FileUtil;
import net.morimekta.util.Strings;
import net.morimekta.util.collect.UnmodifiableList;
import net.morimekta.util.collect.UnmodifiableMap;
import net.morimekta.util.lexer.UncheckedLexerException;

public class ProgramLoader {
    private final GlobalRegistry globalRegistry;
    private final ThriftParser thriftParser;
    private final ThriftParser providenceParser;

    public ProgramLoader() {
        this(false, false, true);
    }

    public ProgramLoader(boolean requireFieldId, boolean requireEnumValue, boolean allowLanguageReservedNames) {
        this(new GlobalRegistry(), requireFieldId, requireEnumValue, allowLanguageReservedNames);
    }

    private ProgramLoader(@Nonnull GlobalRegistry registry, boolean requireFieldId, boolean requireEnumValue, boolean allowLanguageReservedNames) {
        this.globalRegistry = registry;
        this.thriftParser = new ThriftParser(requireFieldId, requireEnumValue, allowLanguageReservedNames, false);
        this.providenceParser = new ThriftParser(requireFieldId, requireEnumValue, allowLanguageReservedNames, true);
    }

    public ProgramRegistry load(File file) throws IOException {
        return this.load(file.toPath());
    }

    public ProgramRegistry load(Path file) throws IOException {
        try {
            return this.loadInternal(file, new ArrayList<String>());
        }
        catch (ThriftException e) {
            if (e.getFile() == null) {
                e.setFile(file.getFileName().toString());
            }
            throw e;
        }
    }

    private ProgramRegistry loadInternal(Path inFile, List<String> loadStack) throws IOException {
        ProgramDeclaration programType;
        loadStack = new ArrayList<String>((Collection<String>)loadStack);
        Path file = FileUtil.readCanonicalPath((Path)inFile.toAbsolutePath().normalize());
        if (!Files.exists(file, new LinkOption[0])) {
            throw new IllegalArgumentException("No such file " + inFile);
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("Unable to load thrift program: " + inFile + " is not a file.");
        }
        String path = file.toString();
        if (loadStack.contains(path)) {
            while (!loadStack.get(0).equals(path)) {
                loadStack.remove(0);
            }
            loadStack.add(path);
            String prefix = ReflectionUtils.longestCommonPrefixPath((Collection<String>)loadStack);
            if (prefix.length() > 0) {
                loadStack = ReflectionUtils.stripCommonPrefix((List<String>)loadStack);
                throw new IllegalArgumentException("Circular includes detected: " + prefix + "... " + String.join((CharSequence)" -> ", (Iterable<? extends CharSequence>)loadStack));
            }
            throw new IllegalArgumentException("Circular includes detected: " + String.join((CharSequence)" -> ", (Iterable<? extends CharSequence>)loadStack));
        }
        loadStack.add((String)path);
        loadStack = UnmodifiableList.copyOf(loadStack);
        ProgramRegistry registry = this.globalRegistry.registryForPath(path);
        if (registry.getProgram() != null) {
            return registry;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file.toFile()));
        if (ReflectionUtils.isThriftFile(file.toString())) {
            programType = ReflectionUtils.isProvidenceFile(file.toString()) ? this.providenceParser.parse(in, file) : this.thriftParser.parse(in, file);
        } else {
            throw new IllegalArgumentException("Not a known providence source format: " + inFile);
        }
        for (IncludeDeclaration include : programType.getIncludes()) {
            String includePath = include.getFilePath();
            Path location = file.getParent().resolve(includePath).normalize();
            registry.addInclude(include.getProgramName(), this.loadInternal(location, (List<String>)loadStack));
        }
        CProgram program = this.convert(path, programType);
        registry.setProgramType(programType);
        registry.setProgram(program);
        return registry;
    }

    public GlobalRegistry getGlobalRegistry() {
        return this.globalRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CProgram convert(String path, ProgramDeclaration program) throws ThriftException {
        UnmodifiableList.Builder declaredTypes = UnmodifiableList.builder();
        UnmodifiableList.Builder constants = UnmodifiableList.builder();
        UnmodifiableMap.Builder typedefs = UnmodifiableMap.builder();
        UnmodifiableList.Builder services = UnmodifiableList.builder();
        ProgramRegistry registry = this.globalRegistry.registryForPath(path);
        File dir = new File(path).getParentFile();
        for (IncludeDeclaration includeDeclaration : program.getIncludes()) {
            String includePath = new File(dir, includeDeclaration.getFilePath()).getPath();
            registry.addInclude(includeDeclaration.getProgramName(), this.globalRegistry.registryForPath(includePath));
        }
        String fileName = new File(path).getName();
        for (Declaration declaration : program.getDeclarationList()) {
            if (declaration instanceof EnumDeclaration) {
                this.registerEnum(program, (EnumDeclaration)declaration, declaredTypes, registry);
                continue;
            }
            if (declaration instanceof MessageDeclaration) {
                this.registerMessage(fileName, program, (MessageDeclaration)declaration, declaredTypes, registry);
                continue;
            }
            if (declaration instanceof ServiceDeclaration) {
                this.registerService(fileName, program, (ServiceDeclaration)declaration, (UnmodifiableList.Builder<CService>)services, registry);
                continue;
            }
            if (declaration instanceof TypedefDeclaration) {
                String targetType = ((TypedefDeclaration)declaration).getType();
                typedefs.put((Object)declaration.getName(), (Object)targetType);
                registry.registerTypedef(TypeReference.ref((String)program.getProgramName(), (String)declaration.getName()), TypeReference.parseType((String)program.getProgramName(), (String)targetType));
                continue;
            }
            if (!(declaration instanceof ConstDeclaration)) continue;
            TypeReference constRef = TypeReference.ref((String)program.getProgramName(), (String)declaration.getName());
            TypeReference typeRef = TypeReference.parseType((String)program.getProgramName(), (String)((ConstDeclaration)declaration).getType());
            ConstValueProvider valueProvider = new ConstValueProvider((TypeRegistry)registry, program.getProgramName(), typeRef, ((ConstDeclaration)declaration).getValueTokens());
            PDescriptorProvider typeProvider = registry.getTypeProvider(typeRef);
            constants.add((Object)new CConst(declaration.getDocumentation(), program.getProgramName(), declaration.getName(), typeProvider, valueProvider, this.makeAnnoatations(declaration.getAnnotations())));
            registry.registerConstant(constRef, valueProvider);
        }
        try {
            for (Declaration declaration : program.getDeclarationList()) {
                TypeReference reference = TypeReference.ref((String)program.getProgramName(), (String)declaration.getName());
                if (declaration instanceof EnumDeclaration) {
                    this.validateEnum((EnumDeclaration)declaration);
                    continue;
                }
                if (declaration instanceof MessageDeclaration) {
                    this.validateMessage(fileName, program, registry, (MessageDeclaration)declaration);
                    continue;
                }
                if (declaration instanceof ServiceDeclaration) {
                    PService service = registry.requireService(reference);
                    service.getExtendsService();
                    for (PServiceMethod method : service.getMethods()) {
                        method.getResponseType();
                        method.getResponseType();
                    }
                    continue;
                }
                if (declaration instanceof TypedefDeclaration) {
                    registry.getTypeProvider(reference).descriptor();
                    continue;
                }
                if (!(declaration instanceof ConstDeclaration)) continue;
                try {
                    registry.getConstantValue(reference);
                }
                catch (UncheckedLexerException e) {
                    throw e.getCause();
                    return new CProgram(path, program.getDocumentation(), program.getProgramName(), this.makeNamespaces(program.getNamespaces()), (Collection<String>)this.getIncludedProgramNames(program), program.getIncludes().stream().map(IncludeDeclaration::getFilePath).collect(Collectors.toSet()), (Map<String, String>)typedefs.build(), (Collection<PDeclaredDescriptor<?>>)declaredTypes.build(), (Collection<CService>)services.build(), (Collection<CConst>)constants.build());
                }
            }
        }
        catch (ThriftException thriftException) {
            throw thriftException;
        }
        catch (Exception exception) {
            throw new ThriftException(exception, exception.getMessage(), new Object[0]);
        }
    }

    private void validateEnum(EnumDeclaration declaration) throws ThriftException {
        HashMap<String, EnumValueDeclaration> forName = new HashMap<String, EnumValueDeclaration>();
        HashMap<Integer, EnumValueDeclaration> forId = new HashMap<Integer, EnumValueDeclaration>();
        for (EnumValueDeclaration val : declaration.getValues()) {
            String normalizedName = Strings.c_case((String)val.getName()).toUpperCase(Locale.US);
            if (forName.containsKey(normalizedName)) {
                ThriftToken otherName = ((EnumValueDeclaration)forName.get(normalizedName)).getNameToken();
                throw new ThriftException(val.getNameToken(), "Enum value with name already exists at line %d", otherName.lineNo());
            }
            forName.put(normalizedName, val);
            if (val.getIdToken() == null) continue;
            int id = val.getId();
            if (forId.containsKey(id)) {
                ThriftToken otherId = ((EnumValueDeclaration)forId.get(id)).getIdToken();
                throw new ThriftException(val.getNameToken(), "Enum value with ID %d already exists at line %d", id, otherId.lineNo());
            }
            forId.put(id, val);
        }
    }

    private Map<String, String> makeNamespaces(List<NamespaceDeclaration> namespaces) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NamespaceDeclaration nd : namespaces) {
            map.put(nd.getLanguage(), nd.getNamespace());
        }
        return map;
    }

    private void validateMessage(String fileName, ProgramDeclaration program, ProgramRegistry registry, MessageDeclaration mt) throws ThriftException {
        PMessageDescriptor descriptor = registry.requireMessageType(TypeReference.ref((String)program.getProgramName(), (String)mt.getName()));
        try {
            CInterfaceDescriptor iFace = (CInterfaceDescriptor)descriptor.getImplementing();
            if (iFace != null) {
                iFace.addPossibleType(descriptor);
            }
        }
        catch (ClassCastException e) {
            throw new ThriftException(mt.getImplementing(), "Bad implements type: %s is not an interface.", new Object[]{mt.getImplementing()}).setFile(fileName);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new ThriftException(mt.getImplementing(), e.getMessage(), new Object[0]).setFile(fileName);
        }
        HashMap<String, FieldDeclaration> forName = new HashMap<String, FieldDeclaration>();
        HashMap<Integer, FieldDeclaration> forId = new HashMap<Integer, FieldDeclaration>();
        for (PField field : descriptor.getFields()) {
            FieldDeclaration ft = this.findField(mt.getFields(), field.getName());
            if (ft == null) {
                throw new IllegalArgumentException("Impossible");
            }
            String normalizedName = Strings.camelCase((String)ft.getName()).toUpperCase(Locale.US);
            if (forName.containsKey(normalizedName)) {
                ThriftToken other = ((FieldDeclaration)forName.get(normalizedName)).getNameToken();
                throw new ThriftException(ft.getNameToken(), "Field with name '%s' already exists on line %d", ft.getName(), other.lineNo()).setFile(fileName);
            }
            forName.put(normalizedName, ft);
            if (ft.getIdToken() != null) {
                int id = ft.getId();
                if (forId.containsKey(id)) {
                    ThriftToken other = ((FieldDeclaration)forId.get(id)).getIdToken();
                    throw new ThriftException(ft.getIdToken(), "Field with id %d already exists on line %d", ft.getId(), other.lineNo()).setFile(fileName);
                }
                forId.put(id, ft);
            }
            try {
                field.getDescriptor();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                ThriftToken type1 = ft.getTypeToken();
                throw new ThriftException(type1, e.getMessage(), new Object[0]).initCause(e).setFile(fileName);
            }
            try {
                field.getArgumentsType();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                AnnotationDeclaration args = this.findAnnotation(ft.getAnnotations(), PAnnotation.ARGUMENTS_TYPE);
                if (args == null || args.getValueToken() == null) {
                    throw new IllegalStateException("");
                }
                throw new ThriftException(args.getValueToken(), e.getMessage(), new Object[0]).initCause(e).setFile(fileName);
            }
            AnnotationDeclaration refEnum = this.findAnnotation(ft.getAnnotations(), PAnnotation.REF_ENUM);
            if (refEnum != null) {
                ThriftToken refEnumValue = refEnum.getValueToken();
                if (PPrimitive.findByName((String)refEnum.getValue()) != null) {
                    throw new ThriftException(refEnumValue, "Primitive type '%s' for ref.enum for '%s' in %s", refEnum.getValue(), field.getName(), descriptor.getName()).setFile(fileName);
                }
                Iterator<FieldDeclaration> dd = registry.getDeclaredType(TypeReference.parseType((String)program.getProgramName(), (String)refEnum.getValue())).orElseThrow(() -> new ThriftException(refEnumValue, "Unknown ref.enum type '%s' for '%s' in %s", refEnum, field.getName(), descriptor.getName()).setFile(fileName));
                if (!(dd instanceof PEnumDescriptor)) {
                    throw new ThriftException(refEnumValue, "'%s' is not an enum for ref.enum '%s' in %s", refEnum.getValue(), field.getName(), descriptor.getName()).setFile(fileName);
                }
            }
            field.getDefaultValue();
        }
        try {
            switch (descriptor.getVariant()) {
                case STRUCT: {
                    CMessageDescriptor sd = (CStructDescriptor)descriptor;
                    if (((CStructDescriptor)sd).getImplementing() == null) break;
                    CInterfaceDescriptor id = ((CStructDescriptor)sd).getImplementing();
                    for (PField iField : id.getFields()) {
                        PField found = ((CStructDescriptor)sd).findFieldByName(iField.getName());
                        FieldDeclaration ft = null;
                        for (FieldDeclaration f2 : mt.getFields()) {
                            if (!f2.getName().equals(iField.getName())) continue;
                            ft = f2;
                            break;
                        }
                        if (found == null || ft == null) {
                            throw new ThriftException(mt.getVariantToken(), "Missing interface field '%s' in %s implementing %s", iField.getName(), sd.getName(), id.getQualifiedName(program.getProgramName())).setFile(fileName);
                        }
                        if (!found.getDescriptor().equals(iField.getDescriptor())) {
                            throw new ThriftException(ft.getTypeToken(), "Type mismatch for field '%s' in %s implementing %s, %s != %s", iField.getName(), sd.getName(), id.getQualifiedName(program.getProgramName()), found.getDescriptor().getQualifiedName(), iField.getDescriptor().getQualifiedName()).setFile(fileName);
                        }
                        if (found.getRequirement() == iField.getRequirement()) continue;
                        throw new ThriftException(ft.getRequirementToken(), "Requirement mismatch for field '%s' in %s implementing %s, %s != %s", iField.getName(), sd.getName(), id.getQualifiedName(program.getProgramName()), found.getRequirement(), iField.getRequirement()).setFile(fileName);
                    }
                    break;
                }
                case UNION: {
                    CMessageDescriptor sd = (CUnionDescriptor)descriptor;
                    if (((CUnionDescriptor)sd).getImplementing() == null) break;
                    CInterfaceDescriptor id = ((CUnionDescriptor)sd).getImplementing();
                    for (CField<CUnion> field : ((CUnionDescriptor)sd).getFields()) {
                        FieldDeclaration cft = mt.getFields().stream().filter(f -> f.getName().equals(field.getName())).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find field source"));
                        PDescriptor pd = field.getDescriptor();
                        if (pd.getType() != PType.MESSAGE) {
                            throw new ThriftException(cft.getTypeToken(), "Field %s in union %s of %s is not a message.", field.getName(), sd.getQualifiedName(), id.getQualifiedName(program.getProgramName())).setFile(fileName);
                        }
                        PMessageDescriptor pmd = (PMessageDescriptor)pd;
                        if (pmd.getImplementing() != null && pmd.getImplementing().equals((Object)id)) continue;
                        throw new ThriftException(cft.getTypeToken(), "Field '%s' in union %s of %s does not implement required interface.", field.getName(), sd.getQualifiedName(), id.getQualifiedName(program.getProgramName())).setFile(fileName);
                    }
                    break;
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new ThriftException(mt.getVariantToken(), e.getMessage(), new Object[0]).initCause(e).setFile(fileName);
        }
    }

    private void registerService(String path, ProgramDeclaration program, ServiceDeclaration serviceType, UnmodifiableList.Builder<CService> services, ProgramRegistry registry) throws ThriftException {
        UnmodifiableList.Builder methodBuilder = UnmodifiableList.builder();
        TypeReference serviceRef = TypeReference.ref((String)program.getProgramName(), (String)serviceType.getName());
        for (MethodDeclaration sm : serviceType.getMethods()) {
            ArrayList<CField<CStruct>> rqFields = new ArrayList<CField<CStruct>>();
            for (FieldDeclaration field : sm.getParams()) {
                rqFields.add(this.makeField((TypeRegistry)registry, path, program.getProgramName(), field, PMessageVariant.STRUCT, null));
            }
            CStructDescriptor request = new CStructDescriptor(null, program.getProgramName(), serviceType.getName() + '.' + sm.getName() + ".request", rqFields, null, null);
            CUnionDescriptor response = null;
            if (!sm.isOneWay()) {
                ArrayList<CField<CUnion>> rsFields = new ArrayList<CField<CUnion>>();
                CField success = new CField(null, 0, PRequirement.OPTIONAL, "success", registry.getTypeProvider(TypeReference.parseType((String)program.getProgramName(), (String)sm.getReturnType())), null, null, this.makeAnnoatations(sm.getAnnotations()), null);
                rsFields.add(success);
                if (sm.getThrowing() != null) {
                    for (FieldDeclaration field : sm.getThrowing()) {
                        rsFields.add(this.makeField((TypeRegistry)registry, path, program.getProgramName(), field, PMessageVariant.UNION, null));
                    }
                }
                response = new CUnionDescriptor(null, program.getProgramName(), serviceType.getName() + '.' + sm.getName() + ".response", rsFields, null, null);
            }
            CServiceMethod method = new CServiceMethod(sm.getDocumentation(), sm.getName(), sm.isOneWay(), request, response, this.makeAnnoatations(sm.getAnnotations()), registry.getServiceProvider(serviceRef));
            methodBuilder.add((Object)method);
        }
        PServiceProvider extendsProvider = null;
        if (serviceType.getExtending() != null) {
            extendsProvider = registry.getServiceProvider(TypeReference.parseType((String)program.getProgramName(), (String)serviceType.getExtending()));
        }
        CService service = new CService(serviceType.getDocumentation(), program.getProgramName(), serviceType.getName(), extendsProvider, (Collection<CServiceMethod>)methodBuilder.build(), this.makeAnnoatations(serviceType.getAnnotations()));
        services.add((Object)service);
        registry.registerService(service);
    }

    private void registerMessage(String path, ProgramDeclaration program, MessageDeclaration messageType, UnmodifiableList.Builder<PDeclaredDescriptor<?>> declaredTypes, ProgramRegistry registry) throws ThriftException {
        CMessageDescriptor type;
        PDescriptorProvider implementing = null;
        if (messageType.getImplementing() != null) {
            implementing = registry.getTypeProvider(TypeReference.parseType((String)program.getProgramName(), (String)messageType.getImplementing().toString()));
        }
        switch (messageType.getVariant()) {
            case STRUCT: {
                ArrayList<CField<CStruct>> fields = new ArrayList<CField<CStruct>>();
                for (FieldDeclaration field : messageType.getFields()) {
                    fields.add(this.makeField((TypeRegistry)registry, path, program.getProgramName(), field, messageType.getVariant(), implementing));
                }
                type = new CStructDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, this.makeAnnoatations(messageType.getAnnotations()), implementing);
                break;
            }
            case UNION: {
                ArrayList<CField<CUnion>> fields = new ArrayList<CField<CUnion>>();
                for (FieldDeclaration field : messageType.getFields()) {
                    fields.add(this.makeField((TypeRegistry)registry, path, program.getProgramName(), field, messageType.getVariant(), implementing));
                }
                type = new CUnionDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, this.makeAnnoatations(messageType.getAnnotations()), implementing);
                break;
            }
            case EXCEPTION: {
                ArrayList<CField<CException>> fields = new ArrayList<CField<CException>>();
                for (FieldDeclaration field : messageType.getFields()) {
                    fields.add(this.makeField((TypeRegistry)registry, path, program.getProgramName(), field, messageType.getVariant(), implementing));
                }
                type = new CExceptionDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, this.makeAnnoatations(messageType.getAnnotations()));
                break;
            }
            case INTERFACE: {
                ArrayList<CField<CInterface>> fields = new ArrayList<CField<CInterface>>();
                for (FieldDeclaration field : messageType.getFields()) {
                    fields.add(this.makeField((TypeRegistry)registry, path, program.getProgramName(), field, messageType.getVariant(), implementing));
                }
                type = new CInterfaceDescriptor(messageType.getDocumentation(), program.getProgramName(), messageType.getName(), fields, this.makeAnnoatations(messageType.getAnnotations()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unhandled message variant " + messageType.getVariant());
            }
        }
        declaredTypes.add((Object)type);
        registry.registerType(type);
    }

    private void registerEnum(ProgramDeclaration program, EnumDeclaration enumType, UnmodifiableList.Builder<PDeclaredDescriptor<?>> declaredTypes, ProgramRegistry registry) {
        int nextValue = 0;
        CEnumDescriptor type = new CEnumDescriptor(enumType.getDocumentation(), program.getProgramName(), enumType.getName(), this.makeAnnoatations(enumType.getAnnotations()));
        ArrayList<CEnumValue> values = new ArrayList<CEnumValue>();
        for (EnumValueDeclaration value : enumType.getValues()) {
            int v = value.getId() > 0 ? value.getId() : nextValue;
            nextValue = v + 1;
            values.add(new CEnumValue(value.getDocumentation(), value.getId(), value.getName(), type, this.makeAnnoatations(value.getAnnotations())));
        }
        type.setValues(values);
        declaredTypes.add((Object)type);
        registry.registerType(type);
    }

    private FieldDeclaration findField(Collection<FieldDeclaration> fields, String name) {
        for (FieldDeclaration field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private Set<String> getIncludedProgramNames(ProgramDeclaration document) {
        TreeSet<String> out = new TreeSet<String>();
        for (IncludeDeclaration include : document.getIncludes()) {
            String program = include.getProgramName();
            if (out.contains(program)) {
                throw new IllegalArgumentException("Program " + document.getProgramName() + " includes multiple programs of name " + program);
            }
            out.add(program);
        }
        return out;
    }

    private <M extends PMessage<M>> CField<M> makeField(@Nonnull TypeRegistry registry, @Nonnull String fileName, final @Nonnull String programName, @Nonnull FieldDeclaration field, @Nonnull PMessageVariant variant, @Nullable PDescriptorProvider implementing) throws ThriftException {
        TypeReference reference = TypeReference.parseType((String)programName, (String)field.getType());
        PDescriptorProvider type = registry.getTypeProvider(reference, this.makeAnnoatations(field.getAnnotations()));
        ConstValueProvider defaultValue = null;
        if (field.getDefaultValueTokens() != null) {
            defaultValue = new ConstValueProvider(registry, programName, reference, field.getDefaultValueTokens());
        }
        PStructDescriptorProvider argumentsProvider = null;
        final AnnotationDeclaration arguments = this.findAnnotation(field.getAnnotations(), PAnnotation.ARGUMENTS_TYPE);
        if (arguments != null) {
            if (PPrimitive.findByName((String)arguments.getValue()) != null) {
                throw new ThriftException(arguments.getValueToken(), "Primitive " + arguments.getValue() + " not allowed as argument type", new Object[0]).setFile(fileName);
            }
            final PDescriptorProvider desc = registry.getTypeProvider(TypeReference.parseType((String)programName, (String)arguments.getValue()), this.makeAnnoatations(field.getAnnotations()));
            argumentsProvider = new PStructDescriptorProvider(){

                @Nonnull
                public PStructDescriptor descriptor() {
                    try {
                        return (PStructDescriptor)desc.descriptor();
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(e.getMessage().replace(" in program '", " for argument type in program '"), e);
                    }
                    catch (ClassCastException e) {
                        throw new IllegalStateException("'" + arguments.getValue() + "' is not a struct for argument type in program '" + programName + "'", e);
                    }
                }
            };
        }
        PRequirement requirement = field.getRequirement();
        if (variant == PMessageVariant.UNION) {
            if (requirement == PRequirement.REQUIRED) {
                throw new IllegalArgumentException("Required field in union");
            }
            requirement = PRequirement.OPTIONAL;
        }
        return new CField(field.getDocumentation(), field.getId(), requirement, field.getName(), type, argumentsProvider, defaultValue, this.makeAnnoatations(field.getAnnotations()), implementing);
    }

    private AnnotationDeclaration findAnnotation(List<AnnotationDeclaration> annotations, PAnnotation annotation) {
        for (AnnotationDeclaration annotationDeclaration : annotations) {
            if (!annotationDeclaration.getTag().equals(annotation.tag)) continue;
            return annotationDeclaration;
        }
        return null;
    }

    private Map<String, String> makeAnnoatations(List<AnnotationDeclaration> annotations) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (AnnotationDeclaration annotation : annotations) {
            map.put(annotation.getTag(), annotation.getValue());
        }
        return map;
    }
}

