/*
 * Decompiled with CFR 0.152.
 */
package net.morimekta.providence.reflect.parser;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.morimekta.providence.reflect.parser.ThriftTokenType;
import net.morimekta.util.lexer.Token;

public class ThriftToken
extends Token<ThriftTokenType> {
    public static final char kGenericStart = '<';
    public static final char kGenericEnd = '>';
    public static final char kMessageStart = '{';
    public static final char kMessageEnd = '}';
    public static final char kKeyValueSep = ':';
    public static final char kFieldValueSep = '=';
    public static final char kParamsStart = '(';
    public static final char kParamsEnd = ')';
    public static final char kListStart = '[';
    public static final char kListEnd = ']';
    public static final char kLineSep1 = ',';
    public static final char kLineSep2 = ';';
    private static final Pattern RE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_DOUBLE_QUALIFIED_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*[.][_a-zA-Z][_a-zA-Z0-9]*");
    private static final Pattern RE_REFERENCE_IDENTIFIER = Pattern.compile("[_a-zA-Z][_a-zA-Z0-9]*([.][_a-zA-Z][_a-zA-Z0-9]*)*");
    private static final Pattern RE_BLOCK_LINE = Pattern.compile("^([\\s]*[*])?[\\s]?");
    private static final Pattern RE_FIELD_ID = Pattern.compile("([1-9][0-9]*)");
    private static final Pattern RE_ENUM_ID = Pattern.compile("(0|[1-9][0-9]*)");
    private static final Pattern RE_INTEGER = Pattern.compile("-?(0|[1-9][0-9]*|0[0-7]+|0x[0-9a-fA-F]+)");
    private static final Pattern RE_REAL = Pattern.compile("-?(0?\\.[0-9]+|[1-9][0-9]*\\.[0-9]*)([eE][+-]?[0-9][0-9]*)?");

    public ThriftToken(char[] fb, int off, int len, @Nonnull ThriftTokenType type, int lineNo, int linePos) {
        super(fb, off, len, (Object)type, lineNo, linePos);
    }

    public boolean isSymbol(char symbol) {
        return this.len == 1 && this.fb[this.off] == symbol;
    }

    public String parseDocumentation() {
        String block = this.toString().trim();
        String[] lines = block.split("\\r?\\n", Short.MAX_VALUE);
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(RE_BLOCK_LINE.matcher(line).replaceFirst(""));
            builder.append('\n');
        }
        return builder.toString().trim();
    }

    public boolean isFieldId() {
        return RE_FIELD_ID.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isEnumValueId() {
        return RE_ENUM_ID.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isInteger() {
        return RE_INTEGER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isReal() {
        return RE_REAL.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isIdentifier() {
        return RE_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isQualifiedIdentifier() {
        return RE_QUALIFIED_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isDoubleQualifiedIdentifier() {
        return RE_DOUBLE_QUALIFIED_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }

    public boolean isReferenceIdentifier() {
        return RE_REFERENCE_IDENTIFIER.matcher((CharSequence)((Object)this)).matches();
    }
}

